import {
    parseExtensionToken,
    EXTENSION_ROLE_VIEWER,
    EXTENSION_PERMISSION_STATE_GRANTED,
} from 'util/extensions';
/* eslint-disable camelcase */

export const TEST_EXTENSION_ITEMS = Object.freeze([{
    id: '12345abcdef54321fedcba',
    anchor: 'video_overlay',
    viewer_url: 'https://example.com/extension/viewer.html',
}]);

export function createExtensionToken(userId, role) {
    const tokenParts = [
        {
            alg: 'HS256',
            typ: 'JWT',
        },
        {
            exp: 1492715406,
            opaque_user_id: 'UgUlLl3AtY1668rlM2hFq',
            channel_id: '154019495',
            role,
            user_id: userId,
            pubsub_perms: {
                listen: [
                    'broadcast',
                    'whisper-UgUlLl3AtY1668rlM2hFq',
                ],
                send: [
                    '*',
                ],
            },
        },
        // TODO signature should be validated
        'lolwhatever',
    ];

    return `${btoa(JSON.stringify(tokenParts[0]))}.${btoa(JSON.stringify(tokenParts[1]))}.${tokenParts[2]}`;
}

export function createExtension() {
    const extensionId = `8cpbw532b2uhoztmsprnpw1${Math.floor(1e6 * Math.random()).toString(36)}`;

    return {
        tokens: [
            {
                extension_id: extensionId,
                token: createExtensionToken(undefined, EXTENSION_ROLE_VIEWER),
                grants: {},
            },
        ],
        installed_extensions: [
            {
                extension: {
                    id: extensionId,
                    state: 'Testing',
                    version: '0.0.1',
                    anchor: 'video_overlay',
                    panel_height: 0,
                    author_name: `author_${Math.floor(1e6 * Math.random()).toString(36)}`,
                    support_email: `email_${Math.floor(1e6 * Math.random()).toString(36)}@whatever.com`,
                    name: `${Math.floor(1e6 * Math.random()).toString(36)} Video Overlay`,
                    description: 'This is a test overlay extension. Probably not good for much. Move along, folks',
                    summary: 'Blank video overlay',
                    viewer_url: 'https://d2o1v271fq118f.cloudfront.net/viewer.html?version=0.0.1',
                    config_url: 'https://d2o1v271fq118f.cloudfront.net/config.html',
                    icon_url: 'https://d2o1v271fq118f.cloudfront.net/icon.png',
                    screenshot_urls: [
                        'https://d2o1v271fq118f.cloudfront.net/screen1.png',
                        'https://d2o1v271fq118f.cloudfront.net/screen2.png',
                        'https://d2o1v271fq118f.cloudfront.net/screen3.png',
                        'https://d2o1v271fq118f.cloudfront.net/screen4.png',
                        'https://d2o1v271fq118f.cloudfront.net/screen5.png',
                    ],
                    asset_urls: [
                        'https://d2o1v271fq118f.cloudfront.net/viewer.html',
                    ],
                    installation_count: 6,
                    can_install: true,
                    request_identity_link: true,
                    sku: '',
                    vendor_code: '',
                },
                installation_status: {
                    extension_id: extensionId,
                    activation_config: {
                        anchor: 'video_overlay',
                        slot: 'extension-overlay-1',
                    },
                    activation_state: 'active',
                    can_activate: true,
                },
            },
        ],
    };
}

export function createExtensionParsed() {
    const { installed_extensions: installs, tokens } = createExtension();
    return installs.map(({ extension }) => {
        const token = tokens.filter(token => extension.id === token.extension_id)[0].token;
        const parsedToken = parseExtensionToken(token);
        return {
            id: extension.id,
            name: extension.name,
            summary: extension.summary,
            anchor: extension.anchor,
            version: extension.version,
            viewerUrl: extension.viewer_url,
            sku: extension.sku,
            vendorCode: extension.vendor_code,
            state: extension.state,
            token: parsedToken,
            lastUserIdentityLinkState: parsedToken.permissionsState === EXTENSION_PERMISSION_STATE_GRANTED,
            supportsIdentityLinking: extension.request_identity_link,
        };
    });
}
