import React from 'react';
import { shallow } from 'enzyme';

export function combineProps(defaultPropGenerator, overrides) {
    const defaultProps = defaultPropGenerator ? defaultPropGenerator() : {};

    if (typeof overrides === 'function') {
        return Object.assign(defaultProps, overrides(defaultProps));
    } else if (typeof overrides === 'object') {
        return Object.assign(defaultProps, overrides);
    }

    return defaultProps;
}

export function setupShallowTest(Component, initialPropGenerator, options) {
    return propOverrides => {
        const combinedProps = combineProps(initialPropGenerator, propOverrides);

        /**
         * Note: "lifecycleExperimental" allows all lifecycle hooks in shallow rendering to be exercised, will be on
         * by default in Enzyme 3.0: https://github.com/airbnb/enzyme/issues/678
         */
        const shallowRenderOptions = Object.assign({ lifecycleExperimental: true }, options);

        return {
            props: combinedProps,
            wrapper: shallow((<Component {...combinedProps} />), shallowRenderOptions),
        };
    };
}
