/**
 * Mock translate Fn for i18n's interpolation functionality
 *
 * If no mapping provided, return string, otherwise, use regexp
 * to interpolate string.
 *
 * const a = mockTranslateFunc('hello {{name}}', { name: 'Rick Sanchez' })
 * a === 'hello Rick Sanchez'
 *
 * @param {String} str
 * @param {Object} map
 * @return {String}
 */
export function mockTranslateFunc(str, map = {}) {
    if (!Object.keys(map).length) {
        return str;
    }

    return Object.keys(map).
        reduce((outStr, currKey) => {
            const regExp = new RegExp(`{{[-]*\\s{0,}${currKey}\\s{0,}}}`, 'gi');
            return outStr.replace(regExp, map[currKey]);
        }, str);
}
