module.exports = {
    rootDir: '../',
    modulePaths: [
        '<rootDir>/src/js',
        '<rootDir>/__tests__',
        '<rootDir>/node_modules',
    ],
    verbose: true,
    moduleFileExtensions: [
        'js',
        'jsx',
        '',
    ],
    moduleNameMapper: {
        '^.+\\.(css|sass)$': 'identity-obj-proxy',
    },
    setupTestFrameworkScriptFile: 'jest-extended',
    setupFiles: [
        '<rootDir>/node_modules/js-polyfills/web.js',
        '<rootDir>/node_modules/js-polyfills/polyfill.js',
        '<rootDir>/__tests__/setup/setup.js',
        '<rootDir>/__tests__/setup/enzyme.js',
    ],
    moduleDirectories: [
        'node_modules',
        '<rootDir>/src/js',
        '<rootDir>/__tests__',
        '<rootDir>/src/html',
    ],
    testMatch: [
        '<rootDir>/__tests__/src/js/**/?(*.)test.js?(x)',
    ],
    watchPathIgnorePatterns: [
        '<rootDir>/node_modules',
        '<rootDir>/dist',
    ],
};
