/* global module */
/**
 * Conditionally runs the given plugin, if the given predicate is `true`.
 * @class
 *
 * @param {Boolean} predicate if `true`, apply the plugin; otherwise, ignore.
 * @param {WebpackPlugin} plugin
 */
function ConditionalPlugin(predicate, plugin) {
    this.predicate = predicate;
    this.plugin    = plugin;
}

ConditionalPlugin.prototype.apply = function(compilation) {
    if (this.predicate) {
        this.plugin.apply(compilation);
    }
};

module.exports = ConditionalPlugin;
