/* global __dirname, module */
const fs = require('fs');
const path = require('path');

const DEST_PATH = path.resolve(__dirname, '../..', 'build');

/**
 * Create hash-free symlinks to some files, which need to be publicly available
 * under a consistent name.
 * @class
 */
function SymlinkPlugin() {}

SymlinkPlugin.prototype.apply = function(compilation) {
    compilation.plugin('after-emit', function(compilation, callback) {
        var assets = compilation.getStats().toJson({
            hash: true,
            assets: true,
        }).assets;

        Promise.all(Object.keys(assets).map(function(k) {
            var asset = assets[k];
            return new Promise(function(resolve) {
                var assetName = path.basename(asset.name).replace(/\.[0-9a-f]+\./, '.');
                var assetPath = path.resolve(DEST_PATH, path.dirname(asset.name), assetName);
                var target = path.basename(asset.name);
                if (
                    (asset.chunkNames.length === 0 && !/\.(?:swf|html)$/.test(target)) ||
                    (target === assetName)
                ) {
                    // if it doesn't belong to any chunks, or didn't contain a
                    // hash in the original asset name, don't symlink
                    resolve();
                } else {
                    fs.unlink(assetPath, function(err) {
                        if (err && err.code !== 'ENOENT') {
                            compilation.errors.push(err);
                            resolve();
                        } else {
                            fs.symlink(target, assetPath, function(err) {
                                if (err) {
                                    compilation.errors.push(err);
                                }
                                resolve();
                            });
                        }
                    });
                }
            });
        })).then(function() {
            callback();
        });
    });
};

module.exports = SymlinkPlugin;
