/* global __dirname, module, process */
const path = require('path');
const autoprefixer = require('autoprefixer');

const ExtractTextPlugin = require('extract-text-webpack-plugin');

const ROOT_PATH = path.resolve(__dirname, '..');
const SRC_PATH = path.resolve(__dirname, '..', 'src');
const DEV_MODE = (process.env.NODE_ENV !== 'production');

module.exports = {
    watch: false,
    resolve: {
        modules: [
            path.resolve(SRC_PATH, 'js'),
            'node_modules',
        ],
        alias: {
            'event-emitter': 'wolfy87-eventemitter',
            sinon: 'sinon/pkg/sinon.js',
        },
        extensions: ['.js', '.jsx'],
    },
    module: {
        rules: [
            {
                test: /\.jsx?$/,
                include: [
                    path.resolve(SRC_PATH, 'js'),
                    path.resolve(ROOT_PATH, 'tests'),
                    path.resolve(ROOT_PATH, 'node_modules/pubsub-js-client'),
                    path.resolve(ROOT_PATH, 'node_modules/client-event-reporter'),
                    path.resolve(ROOT_PATH, 'node_modules/player-core-loader'),
                    path.resolve(ROOT_PATH, 'node_modules/extension-coordinator'),
                ],
                use: [
                    {
                        loader: 'babel-loader',
                        options: {
                            presets: [
                                ['es2015', { modules: false }],
                                'react',
                            ],
                        },
                    },
                ],
            },
            {
                test: /\.sass$/,
                use: ExtractTextPlugin.extract({
                    fallback: 'style-loader',
                    use: [
                        {
                            loader: 'css-loader',
                            options: {
                                minimize: DEV_MODE ? false : true,
                            },
                        },
                        {
                            loader: 'postcss-loader',
                            options: {
                                plugins: () => [autoprefixer],
                            },
                        },
                        {
                            loader: 'sass-loader',
                            options: {
                                indentedSyntax: true,
                            },
                        },
                    ],
                }),
            },
            {
                test: /\.png$/,
                use: [
                    {
                        loader: 'url-loader',
                        options: {
                            mimetype: 'image/png',
                        },
                    },
                ],
            },
        ],
        noParse: [
            /node_modules\/sinon\//,
        ],
    },
};
