/* global module, process, __dirname */
const path = require('path');
const webpack = require('webpack');
const merge = require('lodash/merge');

const ConditionalPlugin = require('./util/webpack-conditional-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const SymlinkPlugin = require('./util/webpack-symlink-plugin');

const DEST_PATH = path.resolve(__dirname, '..', 'build');
const SRC_PATH = path.resolve(__dirname, '..', 'src');

const CURRENT_DATE = new Date().toISOString().
  slice(0, -5).
  replace(/:/g, '').
  replace(/-/g, '.').
  replace('T', '-');
const CURRENT_COMMIT_HASH = process.env.GIT_COMMIT || 'DEV';
const APP_VERSION = `${CURRENT_DATE}+${CURRENT_COMMIT_HASH}`;

const DEV_MODE = (process.env.NODE_ENV !== 'production');
const SOURCE_MAP = (DEV_MODE ? 'source-map' : false);

const baseOptions = require('./webpack-base.js');

module.exports = merge({}, baseOptions, {
    devtool: SOURCE_MAP,
    entry: {
        'embed-v0': path.resolve(SRC_PATH, 'js', 'embed', 'embedv0'),
        'embed/v1': path.resolve(SRC_PATH, 'js', 'embed', 'embedv1'),
    },
    output: {
        path: DEST_PATH,
        publicPath: '',
        filename: DEV_MODE ? 'js/[name].js' : 'js/[name].[chunkhash].js',
        libraryTarget: 'umd',
        library: ['Twitch', 'video'],
        sourceMapFilename: '[file].map',
    },
    plugins: [
        new ConditionalPlugin(!DEV_MODE, new webpack.optimize.UglifyJsPlugin()),
        new ConditionalPlugin(DEV_MODE, new HtmlWebpackPlugin({
            template: path.resolve(SRC_PATH, 'html', 'embed.html'),
            chunks: ['embed/v1'],
            filename: 'embed.html',
        })),
        new webpack.DefinePlugin({
            'process.env.NODE_ENV': JSON.stringify(process.env.NODE_ENV || 'development'),
            APP_VERSION: JSON.stringify(APP_VERSION),
            I18N_LOCALES: JSON.stringify(require('./smartling.config.json').locales),
        }),
        new SymlinkPlugin(),
    ],
});
