/* global __dirname, process, module */
const glob = require('glob');
const path = require('path');
const webpack = require('webpack');
const merge = require('lodash/merge');

const ExtractTextPlugin = require('extract-text-webpack-plugin');

const DEV_MODE = (process.env.NODE_ENV !== 'production');
const SOURCE_MAP = (DEV_MODE ? 'source-map' : false);
const CURRENT_DATE = new Date().toISOString().
  slice(0, -5).
  replace(/:/g, '').
  replace(/-/g, '.').
  replace('T', '-');
const CURRENT_COMMIT_HASH = process.env.GIT_COMMIT || 'DEV';
const APP_VERSION = `${CURRENT_DATE}+${CURRENT_COMMIT_HASH}`;

const ROOT_PATH = path.resolve(__dirname, '..');

const baseOptions = require('./webpack-base.js');

module.exports = merge({}, baseOptions, {
    devtool: SOURCE_MAP,
    entry: glob.sync('./tests/src/**/*.test.js?(x)').reduce(function(entry, dir) {
        // eslint-disable-next-line no-param-reassign
        entry[path.relative('./tests/src', dir)] = dir;
        return entry;
    }, {
        commons: ['sinon'].concat(glob.sync('./src/**/*.js'), glob.sync('./tests/utils/**/*.js')),
    }),
    resolve: {
        alias: {
            tests: path.resolve(ROOT_PATH, 'tests'),
        },
    },
    node: {
        fs: 'empty',
    },
    output: {
        path: path.resolve(ROOT_PATH, 'tests/build'),
        filename: '[name]',
        sourceMapFilename: '[file].map',
    },
    externals: {
        // `cheerio` is needed by enzyme, the React testing framework by AirBnB
        cheerio: 'window',
        'react/addons': true,
        'react/lib/ExecutionEnvironment': true,
        'react/lib/ReactContext': true,
    },
    plugins: [
        new webpack.optimize.CommonsChunkPlugin({
            name: 'commons',
            filename: 'commons.test.js',
            minChunks: 0,
        }),
        new ExtractTextPlugin({
            filename: 'css/[name].[contenthash].css',
        }),
        new webpack.DefinePlugin({
            'process.env.NODE_ENV': JSON.stringify('test'),
            APP_VERSION: JSON.stringify(APP_VERSION),
            I18N_LOCALES: JSON.stringify(require('./smartling.config.json').locales),
        }),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/pubsub-js-client/, path.resolve(ROOT_PATH, 'tests/fakes/pubsubclient.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/^i18next$/, path.resolve(ROOT_PATH, 'tests/fakes/i18next.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/^player-core$/, path.resolve(ROOT_PATH, 'tests/fakes/playercore.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/^mediaplayer$/, path.resolve(ROOT_PATH, 'tests/fakes/mediaplayer.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/^player-core-loader$/, path.resolve(ROOT_PATH, 'tests/fakes/player-core-loader.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/streamsense.min.js/, path.resolve(ROOT_PATH, 'tests/fakes/comscore.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/bigscreen/, path.resolve(ROOT_PATH, 'tests/fakes/bigscreen.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/resize-observer-polyfill/, path.resolve(ROOT_PATH, 'tests/fakes/resize-observer.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/^extension-coordinator$/, path.resolve(ROOT_PATH, 'tests/fakes/extension-coordinator.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/vendor\/apstag/, path.resolve(ROOT_PATH, 'tests/fakes/apstag.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/util\/ima/, path.resolve(ROOT_PATH, 'tests/fakes/util/ima.fake.js')),
        // eslint-disable-next-line max-len
        new webpack.NormalModuleReplacementPlugin(/util\/storage/, path.resolve(ROOT_PATH, 'tests/fakes/local-store.fake.js')),
    ],
});
