# Twitch Event
### PLAYER_INIT
    - emitted when backend has finished initializing
        - video.js
            - `self._loadVideoAPI`
                - Loads video instance into middleware
        - analytics/analytics.js
            - `this.onBackendInit`
                - sets tracking property `backend` and `backend_version`
        - ui/main.jsx
            - sets `$(root).attr('data-initializing')` to false

### CONTENT_SHOWING
    - emitted when playback.playing and playback.hasPlayed are newly true
        - twitch-player2.js
            - `attachPlayer`
                - sets `playerHasStarted` to true
            - `attachEventListeners`
                - tracks `video_started`

### PLAYBACK_STATISTICS
    - Emitted when playback stats have changed
        - video.js
            - `onPlaybackStats`
                - Dispatches stats to store

### CHANSUB_REQUIRED (FLASH ONLY)
    - Emitted in flash when channel subscription is needed
        - flash.js
            - Fires a `TwitchEvents.RESTRICTED` event

### VIDEO_FAILURE (FLASH ONLY)
    - Fired in flash when video plaback has failed
        - backend/flash.js
            - `onVideoFailure`
                - Emits an `OFFLINE` event
                - If ended, emit ended
                - Changes readyState to 0
                - pauses timer and timeupdates (omg.)

### FORMATS (FLASH ONLY)
    - Fired in flash when QUALITIES change
        - backend/flash.js
            - `onVideoFormats`
                - sets formats to equal the new qualities

### ABS_STREAM_FORMAT_CHANGE
    - Fired when abs makes a format change
        - video.js
            - `onABSStreamFormatChange`
                - if quality has changed, emit an `ABS_STREAM_FORMAT_CHAGE` event (bubble up)
        - analytics/analytics.js
            - `onABSStreamFormatChange`
                - fires a tracking event to spade with payload

### FORMAT_CHANGED (FLASH ONLY)
    - Fired when quality changes in flash
        - backend/flash.js
            - `onVideoFormatChanged`
                - Emits a quality change event from flash

### TIME_CHANGE (FLASH ONLY)
    - Used in flash to call `setTimerAndSendTimeUpdate(time)`
        - `onVideoTimeChange`
            - Gets a `TIME_CHANGE` event from flash
            - sets time on flash timer (omg.)
            - emits a `MediaEvents.TIME_UPDATE` with the current time

### BUFFER_CHANGE
    - Used flash, mediaplayer, player-core to signal UI that the buffer has changed (buffer.start, buffer.end)
        - video.js
            - `onBufferChange`
                - dispatches `updateBufferValues`

### SEGMENT_CHANGE
    - Used in flash, mediaplayer, player-core to signal UI that a new segment is being rendered. Each segment has metadata on it.
        - video.js
            - `segmentChangeHandler`
                - Part of `trackTimeToStableQuality` which fires when there are two segments in a row with the same quality
                - sends a `quality_change_complete` tracking event to spade

        - analytics/latency.js
            - _onSegmentChange
                - sends `latency_report_playback` tracking event with segment metadata

        - backend/mediaplayer.js and backend/player-core.js:onID3Tag
            - When an ID3 event is fired from mediaplayer/player-core, it checks to id3 tags for TOFN or TXXX.
                - if TOFN, we emit `SEGMENT_CHANGE` to video.js wiuth the name of the first TOFN segment
                - if TXXX, we check to see if the id3 tag is not content
                    - if the id3 tag is a commercial, we emit a `MIDROLL_REQUESTED` event to video.js

        - backend/player-core.js
            - `onVariantSwitchRequested`
                - if a quality change has been requested, this method will check each `SEGMENT_CHANGE` event to see if the segments quality matches the requested quality
                - if they equal each other, it will fire a `QUALITY_CHANGE` event

### USHER_FAIL_ERROR (FLASH ONLY)
    - Emitted by flash to inform UI that a vod is restricted
        - state-tracker.js
            - `this._updateIsVODRestricted`
                -  Emits an `EVENT_STATE_UPDATE` event (omg.)
                - If VOD
                    - fetch videoInfo and viewerInfo, then make a request to isVODRestricted
                    - then Emit `EVENT_STATE_UPDATE`

### CAPTION_UPDATE
    - Emitted by flash, player-core, mediaplayer to let UI know when captions have changed
        - video.js
            - fetches captions data from `backend.getCaption()` and dispatches it to store.

### SEEK_FAILED (FLASH ONLY)
    - Used to let flash.js know if seeking has failed
        - backend/flash.js
            - `onVideoSeekFailed`
                - sets seeking to false

### VARIANT_SWITCH_REQUESTED (PLAYER-CORE ONLY)
    - Used in player-core to let UI know a quality change request has been made
        - backend/player-core.js
            - `onVariantSwitchRequested`
                - Adds a listener on `SEGMENT_CHANGE` and fires a `QUALITY_CHANGE` event when the requested quality matches the segments quality

### VIEWERS_CHANGE
    - Emitted to web-client and embeds to let them know viewer count has changed. This event is fired by dispatching `updateViewerCount`.
        - twitch-player2.js
            - sets the viewer count on `channel.stream.viewers`
        - pubsub.js
            - `_onPubSubMessage`
                - dispatches `updateViewerCount`
        - actions/streamMetadata.js
            - `fetchLiveStreamMetadata`
                - dispatches `updateViewerCount` when `streamInfo` resolves

### STREAM_LOADED (FLASH ONLY)
    - Fired when live stream loads
        - sets channel, timer and pauses timer updates

### VIDEO_LOADED (FLASH ONLY)
    - Used when VOD has loaded
        - sets videoId and readyState, sets timer to 0

### VIDEO_PAUSED (FLASH ONLY)
    - Used when flash pauses
        - emits `PAUSE` event

### QUALITY_CHANGE
    - Fired when the backend has successfully switched qualities
        - video.js
            - `initEvents`
                - Adds listener to QUALITY_CHANGE
                    - dispatches `setCurrentQuality`
                    - dispatches `incrementQualityChangeCount`
                        - changes `analytics.qualityChangeCount`
                        - is sent with minutes watched tracking event
                    - dispatches `setQualities`

### ONLINE
    - Fired when onlineStatus changes to ONLINE
    - Responds to setOnline(true)
        - video.js
            - onLoadedMetadata
                - If we get a LOADED_METADATA event, and the current stream is LIVE, the stream is ONLINE

### OFFLINE
    - Fired when onlineStatus changes to ONLINE
    - Responds to setOnline(false)
        - pubsub.js
            - _onPubSubMessage
                - If we get a `stream-down` from pubsub, we set onlineStatus to false
        - video.js
            - onOffline
                - If we get an OFFLINE event from the backend, we set stream offline
        - player-core.js
            - onOfflineError
                - backend emits ended and offline - sets this.offline to true
                - this.offline is used in `getEnded`
        - mediaplayer.js
            - _onOfflineError
                - backend emits offline and ended
        - hls.js
            - self.attach
                - if we get a MEDIA_ERR_SRC_NOT_SUPPORTED, we fire offline and ended
        - flash.js
            - onVideoFailure
                - If the video fails, we fire OFFLINE and set ended to true

### RESTRICTED (FLASH ONLY)
    - Fired in flash when a subscription is needed to view the content
    - flash.js
        - onVideoChanSubReqired

### CASTING_CHANGE
    - Fired when initDefaults, onSessionUpdate, onReceiver, onMediaChange is fired (whenever content is loaded, or when chromecast becomes available)
        - video.js
            - initEvents
                - sets the current castingState in the store

### THEATRE_CHANGE
    - Fired from middleware to webclient when setTheatreMode is called
        - video.js
            - self.setTheatre
                - Exposed to outside devs, allowing to set theatremode
        - host.js
            - dispatches setTheatreMode when host recieves a METHOD_SET_THEATRE postMessage
        - ui/containers/buttons/theatre-mode-button
            - this.props.enableTheatreMode and this.props.disableTheatreMode

### MIDROLL_REQUESTED
    - Fired from backends to video.js to dispatch a requestAds(MIDROLL) action
        - flash.js
            - onMidrollRequested
                - Propagates MIDROLL_REQUESTED from flash backend
        - mediaplayer.js
            - _attachInternalListeners
                - on ID3 event, if the id3 event includes a TXXX tag, we check to see if the tag is a commercial
                - if a commercial, then fire a MIDROLL_REQUESTED event
        - player-core.js
            - onID3Tag
                - Same as mediaplayer.js

### MANIFEST_EXTRA_INFO
    - When the backend has recieved the master manifest, we emit this event
        - mediaplayer.js
            - on READY event
                - we normalize the manifest from the backend and send it to video.js
        - player-core.js
            - onHLSMasterParsed
                - normalize the master manifest and pass it up to video.js
        - flash.js
            - same
        - video.js
            - on MANFEST_EXTRA_INFO
                - dispatch setManifestInfo
                - dispatch setLoading true
                - set initial quality

### TRANSITION_TO_COLLECTION_VOD
    - Emits event from middleware to web client to transition to VOD in playlist
        - Fired when `selectCollectionVideo` is dispatched
            - If current playerType is `site`, and not fullscreen, we transition to the collection vod

### TRANSITION_TO_RECOMMENDED_VOD
    - Emits event from middleware to web client to transition to VOD in playlist
        - Fired when `selectRecommendedVideo` is dispatched
            - If current playerType is `site`, we transition to the recommended vod

### STITCHED_AD_START
    - Event from player-core and mediaplayer to signal a stitched ad has started
        - player-core.js
            - onSpliceOut
                - STITCHED_AD_START event is fired
        - mediaplayer.js
            - on SPLICE_OUT event, we emit the STITCHED_AD_START event
        - video.js
            - onStitchedAdStart
                - if we have a URL associated with the STITCH_AD_START event, we dispatch a setAdClickThrough action
                - we setCurrentAdMetadata with contentType STITCHED and rollType MIDROLL

### STITCHED_AD_END
    - Event from player-core and mediaplayer to signal a stitched ad has ended
        - player-core.js
            - onSpliceIn
                - STITCHED_AD_END event is fired
        - mediaplayer.js
            - on SPLICE_OUT event, we emit the STITCHED_AD_END event
        - video.js
            - onStitchedAdEnd
                - dispatches clearCurrentAdMetadata

### PERSISTENT_PLAYER_TOGGLE
    - Fired from event middleware to webclient to set `persistenceEnabled` in localStorage. Fired when enablePlayerPersistence or disablePlayerPersistence is dispatched
        - ui/containers/settings/advanced-menu
            - toggleMiniPlayer

### STATS_UPDATE
    - When stats.enabled is true we setInterval a stats update
        - Nothing is listening to it

### PROMPT_LOGIN_MODAL
    - Fired when user clicks on Follow Notification - and prompts the login modal. Dispatched by promptLoginModal
        - follow-panel-hoc
            - promptLoginModal

### OPEN_STREAM
    - Fired when a user on frontpage clicks on the carosel player - opens the channel
        - dispatched by emitOpenStream
        - ui/info
            - if playerType is PLAYER_FRONTPAGE, on click emitOpenStream

# Media Events
### LOADSTART
    - Fired from flash/mediaplayer/chromecast when .load is called
        - mediaplayer.js
            - load
                - after the src is loaded into mediaPlayer, we emit LOADSTART
        - flash.js
            - onVideoLoadStart
                - if we loaded a quality
                - set networkState to NETWORK_LOADING
                - set duration to 0
                    - emit DURATION_CHANGE
                - sets timer with the videoTime from flash
                - pauseTimerAndPeriodicTImeUpdates
        - state-tracker.js
            - handleEvent
                - sets hasCurrentStreamPlayed to false
                - resets timeline metadata
                - makes API call to videoInfo to check if vod is restricted
        - analytics.js
            - onLoadStart
                - We remake the minutes-watched timer
                - zero out bufferEmptyCount
                - set hasPlayed to false
                - if live
                    - We trackView on countessTracker
                    - fetch communityData and channelInfo
                        - dispatch setCommunitiesData
                    - We call setProperties with a Promise that returns tracking info
                - if VOD
                    - we set properties with channelInfo and videoInfo
        - ui/prevent-refresh-dialog.js
            - onLoadStart
                - set the locally scoped channel var
                - zero out viewers and endedTime
                - detect if user has refreshed the page

### ERROR
    - Fired from backends when an error has occured
        - video.js
            - onError
                - we dispatch the error to store
        - flash.js
            - onVideoError
                - if there is a pending channel
                    - we emit a CHANNEL_ERROR
                - if there's a pending video
                    - we emit a VIDEO_ERROR
                - if it's a flash error
                    - emit a FLASH_ERROR
                - otherwise emit an UNKNOWN_ERROR
        - mediaplayer.js
            - _onAuthError
                - if the retry fails, we fire an `Authorization error`
            - on ERROR event from mediaPlayer
                - depending on error type from mediaplayer, we set this._mediaError and then emit that with the ERROR event
        - player-core.js
            - onFatalError
                - We get an errorcode from player-core and map it to an existing error message
                - emit that error message up to video.js
            - onAuthError
                - same as mediaplayer

### LOADED_METADATA
    - Fired when backend has recieved master manifest
    - player.js
        - init
            - on LOADED_METADATA, dispatch setCanFullScreen (needed for iOS)
    - state-tracker.js
        - Check if vod is restricted
    - video.js
        - onLoadedMetadata
            - dispatch ACTION_TOGGLE_CAPTIONS, setting it false (need to reset captions due to persistent player)
            - dispatch setQualities
            - checks the allowedQualities and sets an acceptable quality
            - dispatches updateDuration
            - if live, setOnline(true)
            - if autoplay, _dispatchPreroll
            - if live, fetchLiveStreamMetadata (????)
    - ui/resume-vod.js
        - _onLoadedMetadata
            - if content is live
                - set this._streamTimeOffset to backends videoInfo.stream_time_offset
            - if its a collection, not a VOD, resumeWatch.isSeeked(???), and no time, return
            - if no userId
                - get videoInfo, and seek to the time stored in localStorage
            - if userId
                - make API call to endpoint
                    - seek to the time from the endpoint
    - twitch-player2
        - sets broadcastId and playSessionId on videoProperties

### CAN_PLAY
    - Fired from backend when content is ready
        - mediaplayer.js
            - Emitted on READY
        - player-core
            - Emitted from video tag
        - flash.js
            - Propagated up from flash
        - analytics.js
            - if this.isSeekInProgress
                - track a VOD_SEEK event
            - set timeStampBeforeSeek to current time

### PLAYING
    - Fired from backends when contented has started playing
        - state-tracker.js
            - handleEvent
                - if hasn't played yet, and theres's a VOD id
                    - _retrieveTimelineMetadata
                - set _hasCurrentStreamPLayed to true
        - video.js
            - onPlaying
                - clears any errors
                - setLoading to false
                - update playback state in store
            - trackTimeToStableQuality
                - gets the time from playing to stable quality then sends tracking event
        - analytics.js
            - onPlaying
                - Fire buffer-refill if there was a buffer empty previously
                - if hasn't played yet, fire a video-play tracking event
                - notify valveClient we've started playing
                - dispatch sendPlayerBeacon and sendVideoBeacon Comscore actions
            - onQualityChange
                - get selected qualuty and set property on it
                - sets quality and stream_format
        - comscore.js
            - onPlaying
                - if no current ad
                    - send a comscore playVideoContentPart event
        - ui/age-restriction-overlay.js
            - _onPlaying
                - if an overlay exists
                    - mute the player
                    - pause content
        - ui/info.js
            - onPlaying
                - hideVideoBackgroundImage

### WAITING
    - Fired from backends when content is buffering
        - video.js
            - onWaiting
                - setLoading to true
                - update playback state to waiting
            - captureBufferEmpties
                - if not seeking, incredment buffer empties
        - analytics.js
            - onWaiting
                - if not seeking, fire a BUFFER_EMPTY tracking event

### SEEKING
    - Fired from backends when seeking has occured
        - video.js
            - onWaiting
                - setLoading to true
                - update playback state to waiting
        - analytics.js
            - onSeeking
                - if hasPlayed and not seeking, set seeking to true
                - set lastSeekTime to Date.now()
        - comscore.js
            - onSeeking
                - if hasPlayed and is not paused
                    - if ended, reset tag
                - otherwise call stop on comscore streamingTag
        - ui/controls
            - onSeeking
                - showControls for a moment before hiding

### SEEKED
    - Fired from backends when seeking has completed
        - video.js
            - onSeeked
                - if current screen is VOD_RECOMMENDATION_SCREEN, pop the screen

### ENDED
    - Fired from backend when content has ended
        - video.js
            - onEnded
                - update playback state to show ended
                - if live request postroll ad
        - analytics.js
            - onEnded
                - resets the minutes watched timer
                - resets bufferEmptyStartTime
                - tracks VIDEO_END
        - comscore.js
            - onEnded
                - stop() is called
                - ended is set to true

### DURATION_CHANGE
    - Fired from backend when the duration of content is loaded or changes
        - video.js
            - onDurationChange
                - dispatch updateDuration in store

### TIME_UPDATE
    - Fired from backend as current time changes
        - video.js
            - onTimeUpdate
                - dispatches updateCurrentTime
            - if edge or safari
                - on TIME_UPDATE, setLoading to false

### PLAY
    - Fired from backend when the play button is hit
        - persistent-player/component.js
            - used to detemine `isPlaying`
        - video.js
            - onWaiting
                - sets loading to true
                - sets playback state to waiting
        - event-emitter-middleware
            - ACTION_AD_PLAY
                - fired when an Ad starts/resumes playing

### PAUSE
    - Fired from backend when pause button is hit
        - persistent-player/component
            - used to determine `isPlaying`
        - video.js
            - onPause
                - if not an IMA ad, update playback state to PAUSED
        - event-emitter-middleware
            - ACTION_AD_PAUSE
                - fired when an Ad pauses
        - analytics.js
            - onPause
                - resets minutesWatchedTimer
        - comscore.js
            - onPause
                - if no Ad is showing, stop comscore

### VOLUME_CHANGE (NOT CONSUMED)
    - Fired from backend when volume has changed

### RATE_CHANGE
    - Fired from backend when playback rate has changed
        - video.js
            - onRateChange
                - dispatches playbackRateChanged to store
