var assert = require('assert');
var Base64 = require('js-base64').Base64;

describe('T1 | buffer-refill', function() {
    it('should fire buffer-refill', function () {
        let bufferRefillFired = false;

        browser.cdp('Network', 'enable');
        browser.on('Network.requestWillBeSent', (params) => {
            const data = Base64.decode(params.request.postData);

            if (data.includes('buffer-refill')) {
                bufferRefillFired = true;
            }
        });

        browser.url('https://betaplayer.twitch.tv/?channel=monstercat&debug');
        browser.execute('localStorage.setItem(\'lastAdDisplay\', 9999999999999)');
        browser.refresh();

        // allows the page to load before going offline
        browser.pause(5000);
        browser.cdp('Network', 'emulateNetworkConditions', {
            offline: true,
            latency: 0,
            downloadThroughput: -1,
            uploadThroughput: -1
        });

        // allows time for buffer-empty to be fired
        browser.pause(5000);
        browser.cdp('Network', 'emulateNetworkConditions', {
            offline: false,
            latency: 0,
            downloadThroughput: -1,
            uploadThroughput: -1
        });
        // allows time for buffer-refill to be fired
        browser.pause(5000);

        expect(bufferRefillFired).toBe(true);
    });
});
