#!/usr/bin/env bash

COMMON_BRANCH="${GIT_BRANCH##origin/}"
if [ "${COMMON_BRANCH}" == "master" ]; then
  # Be paranoid about somehow triggering this on 'master' branch
  exit 0
fi

# web/ENV_CREATOR.properties provides tfci_env
# shellcheck disable=SC1091
# shellcheck disable=SC2154
if [ -f web/ENV_CREATOR.properties ]; then
  source web/ENV_CREATOR.properties
  PING_URLS="https://testplayer.twitch.tv/${COMMON_BRANCH}/js/player.js https://staging-${tfci_env}-www.dev.us-west2.twitch.tv"

  for PING_URL in ${PING_URLS}; do
    for TRY in {1..10}; do
      echo -n "Try ${TRY}: Polling ${PING_URL}... "
      STATUS_CODE=$(curl --retry 3 -s -o /dev/null -I -w "%{http_code}" "${PING_URL}")
      echo "${STATUS_CODE}"
      if [ "${STATUS_CODE}" == "200" ]; then
        echo "Ping was successful. Will proceed with smoca"
        break
      fi
      sleep 1s
    done

    if [ "${STATUS_CODE}" != "200" ]; then
      echo "Ping failed. Will not proceed with smoca"
      echo "To proceed, fix the environment, or click ${BUILD_URL}rebuild to force rebuild"
      exit 1
    fi
  done
else
  echo "ENV_CREATOR.properties does not exist. This should not have happened. See log output above to debug"
  exit 1
fi

