import pick from 'lodash/pick';

export const ACTION_SET_ACCESS_TOKEN_PARAMS = 'set access token params';

const ACCESS_TOKEN_PARAMS = [
    'adblock',
    'need_https',
    'platform',
    'player_type',
];

/**
 * Set the Access Token request parameters in the state store.
 *
 * @param {Object} options
 *        Options given by the embedder or computed from the page query params.
 * @return {Object}
 */
export function setAccessTokenParams(options) {
    const params = pick(options, ACCESS_TOKEN_PARAMS);

    return {
        type: ACTION_SET_ACCESS_TOKEN_PARAMS,
        params,
    };
}
