import { IMAManager } from '../ads/ima-manager';
import { BACKEND_PLAYER_CORE } from '../backend/player-core';
import { BACKEND_FLASH } from '../backend/flash';
import { BACKEND_HLS } from '../backend/hls';
import { BACKEND_MEDIA_PLAYER } from '../backend/mediaplayer';
import { DecliningAdsManager } from '../ads/declining-manager';
import { nullAdsManager } from '../ads/null-manager';
import { FlashManager } from '../ads/flash-manager';

export const ACTION_CREATE_ADS_MANAGER = 'create ads manager';

/*
 * Loads and sets a player-appropriate IMA AdsManager
 */
export function createAdsManager(root, backend, store, options = {}) {
    const adsManager = getAdsManager(root, backend, store, options);
    return {
        type: ACTION_CREATE_ADS_MANAGER,
        adsManager,
    };
}

/**
 * Get an ads manager appropriate for the given backend.
 *
 * @param {HTMLElement} root Root element of the player instance
 * @param {Backend} backend
 * @param {Store} store
 * @return {AdManager}
 */
function getAdsManager(root, backend, store, options) {
    switch (backend.getBackend()) {
    case BACKEND_FLASH:
        return new DecliningAdsManager(store, new FlashManager(backend, store));

    case BACKEND_HLS:
    case BACKEND_PLAYER_CORE:
    case BACKEND_MEDIA_PLAYER:
        return new DecliningAdsManager(store, new IMAManager(root, backend, store, options));
    default:
        return nullAdsManager;
    }
}
