import { generate } from '../util/unique-id';

export const ACTION_INCREMENT_QUALITY_CHANGE_COUNT = 'set quality change count';
export const ACTION_RESET_QUALITY_CHANGE_COUNT = 'reset quality change count';
export const ACTION_RESET_PLAY_SESSION = 'reset play session';
export const ACTION_SET_TRACKING_CLIENTS = 'set new tracking clients';

export function incrementQualityChangeCount() {
    return {
        type: ACTION_INCREMENT_QUALITY_CHANGE_COUNT,
    };
}

export function resetQualityChangeCount() {
    return {
        type: ACTION_RESET_QUALITY_CHANGE_COUNT,
    };
}

export function resetPlaySession() {
    return {
        type: ACTION_RESET_PLAY_SESSION,
        playSessionId: generate(),
        playSessionStartTime: Date.now(),
    };
}

export function setTrackingClients(clients) {
    return {
        type: ACTION_SET_TRACKING_CLIENTS,
        clients,
    };
}
