import { channelInfo, streamInfo } from 'api';

export const ACTION_BROADCASTER_INFO_LOADED = 'broadcaster info loaded';

export const NOT_AVAILABLE = 'NOT_AVAILABLE';

export const BROADCASTER_IS_LIVE = 'BROADCASTER_IS_LIVE';
export const BROADCASTER_IS_NOT_LIVE = 'BROADCASTER_IS_NOT_LIVE';

export const BROADCASTER_IS_PARTNER = 'BROADCASTER_IS_PARTNER';
export const BROADCASTER_IS_NOT_PARTNER = 'BROADCASTER_IS_NOT_PARTNER';

/**
 * Indicates that info about a broadcaster has been loaded
 *
 * @param {String} channelName
 * @return {Object}
 */
export function channelInfoFetched(channelName, info) {
    return {
        type: ACTION_BROADCASTER_INFO_LOADED,
        channelName,
        info,
    };
}

export function fetchChannelInfo(channelName) {
    return function(dispatch) {
        return channelInfo(channelName).then(response => {
            const partnerStatus = response.partner ? BROADCASTER_IS_PARTNER : BROADCASTER_IS_NOT_PARTNER;

            return dispatch(channelInfoFetched(channelName, { partnerStatus }));
        });
    };
}

export function fetchStreamInfo(channelName) {
    return function(dispatch) {
        return streamInfo(channelName).then(response => {
            const liveStatus = response.stream ? BROADCASTER_IS_LIVE : BROADCASTER_IS_NOT_LIVE;

            return dispatch(channelInfoFetched(channelName, {
                liveStatus,
                stream: response.stream,
            }));
        });
    };
}
