export const ACTION_SET_DEVICE_NAME = 'set device name';
export const ACTION_SET_CASTING_STATE = 'set casting state';
export const ACTION_START_CASTING = 'start casting';
export const ACTION_STOP_CASTING = 'stop casting';

/**
 * video-api-middleware action to stop casting
 *
 * @return {Object}
 */
export function stopCast() {
    return {
        type: ACTION_STOP_CASTING,
    };
}

/**
 * video-api-middleware action to start casting
 *
 * @return {Object}
 */
export function startCast() {
    return {
        type: ACTION_START_CASTING,
    };
}

/**
 * Set Chromecast device name
 *
 * @return {Object}
 */
export function setDeviceName(deviceName) {
    return {
        type: ACTION_SET_DEVICE_NAME,
        deviceName,
    };
}

/**
 * Sets the casting state (unavailable, available, connecting, connected)
 *
 * @param {Type}
 * @return {Void}
 */
export function setCastingState(castingState) {
    return {
        type: ACTION_SET_CASTING_STATE,
        castingState,
    };
}
