import { fetchRecommendationsSets } from 'ui/player-types/clips/api';

export const ACTION_CLIP_RECOMMENDATIONS_LOADED = 'clip recommendations loaded';
export const CATEGORY_ORDER = ['similar', 'channel', 'game', 'top'];

/**
 * Indicates that a clip's recommendations have been fetched
 *
 * @param {Object} recommendationSets
 *    {
 *        'game': [ { ...clipData }, { ...clipData } ]},
 *        'channel': [ { ...clipData }, { ...clipData } ]},
 *        'similar': [ { ...clipData }, { ...clipData } ]},
 *    }
 * @return {Object}
 */
export function clipRecommendationsLoaded(recommendationId, recommendationSets) {
    return {
        type: ACTION_CLIP_RECOMMENDATIONS_LOADED,
        recommendationId,
        recommendationSets,
    };
}

export function fetchClipRecommendations() {
    return function(dispatch, getState) {
        const clipId = getState().streamMetadata.slug;

        fetchRecommendationsSets(clipId, CATEGORY_ORDER).then(response => {
            dispatch(clipRecommendationsLoaded(clipId, response.clipSets));
        }).catch(error => {
            // eslint-disable-next-line no-console
            console.debug(`fetchClipRecommendations error: ${error}`);
        });
    };
}
