export const ACTION_SET_COMMUNITIES_DATA = 'set communities data';
export const ACTION_INVALID_COMMUNITIES_DATA = 'invalid communities data';

/**
 * Set communities data object.
 * @param {Object} communitiesData
 * @returns {Object}
 */
export function setCommunitiesData(communitiesData) {
    if (!communitiesData) {
        return {
            type: ACTION_INVALID_COMMUNITIES_DATA,
        };
    }

    return {
        type: ACTION_SET_COMMUNITIES_DATA,
        communities: normalizeCommunitiesData(communitiesData),
    };
}

/**
 * Normalizes api's communities data into state's communities property
 *
 * @param {Object} api's communities data
 * @return {Object} data in the form of state's collection property
 */
function normalizeCommunitiesData({ communities }) {
    // Early return if no community data
    if (communities.length < 1) {
        return {
            data: [],
            ids: '',
        };
    }

    return {
        data: communities,
        ids: joinCommunitiesIds(communities),
    };
}

/**
 * @param {Array} array of communities
 * @return {String} comma-separated string of community ids
 */
export function joinCommunitiesIds(communities) {
    return communities.map(c => c._id).join(',');
}
