const COMSCORE_BEACON_TYPE_VIDEO = '1';
const COMSCORE_BEACON_TYPE_DISTRIBUTED_CONTENT = '7';

const COMSCORE_CLIENT_ID = '6745306'; // Twitch

const COMSCORE_GENRE_VIDEO = '03'; // no context

export const ACTION_RESET_TAG = 'reset tag';

/**
 * Replace the Comscore streaming tag with a new instance
 *
 * @return {Object}
 */
export function resetTag() {
    return {
        type: ACTION_RESET_TAG,
    };
}

/**
 * Sends a player beacon to Comscore.
 */
export function sendPlayerBeacon() {
    return function(_, getState) {
        const { window } = getState();

        pingComscore(
            window,
            COMSCORE_BEACON_TYPE_DISTRIBUTED_CONTENT,
            COMSCORE_CLIENT_ID,
            '2246787049647177590', // Gaming
            '',
            '',
            ''
        );
    };
}

/**
 * Sends a video tracking beacon to Comscore.
 */
export function sendVideoBeacon() {
    return function(_, getState) {
        const { window } = getState();

        pingComscore(
            window,
            COMSCORE_BEACON_TYPE_VIDEO,
            COMSCORE_CLIENT_ID,
            'TWITCH', // Content producer
            'twitch.tv',
            COMSCORE_GENRE_VIDEO,
            ''
        );
    };
}

/**
 * Sends a tracking beacon to Comscore.
 *
 * The parameters sent along with the beacon are ill-documented and were the
 * best-guess attempt at reverse engineering the defunct Comscore implementation
 * in the flash player.
 *
 * @param {String} c1 Tag Type
 * @param {String} c2 Client ID
 * @param {String} c3 Content Producer (UNSURE)
 * @param {String} c4 Full Page URL
 * @param {String} c5 Genre/Content
 * @param {String} c6 unknown
 */
function pingComscore(win, c1, c2, c3, c4, c5, c6) {
    const beacon = {
        c1,
        c2,
        c3,
        c4,
        c5,
        c6,
    };

    if ('COMSCORE' in win) {
        win.COMSCORE.beacon(beacon);
    } else {
        if (!win._comscore) {
            // eslint-disable-next-line no-param-reassign
            win._comscore = [];
        }
        win._comscore.push(beacon);
    }
}
