export const ACTION_USE_EMBED_EVENT_EMITTER = 'use embed event emitter';
export const ACTION_AD_COMPANION_EVENT = 'ad companion rendered';
export const ACTION_EMBED_WHEEL_EVENT = 'wheel event embedded player';
export const ACTION_FIRST_PARTY_ANALYTIC_EVENT = 'first party analytic event';

/**
 * Takes an event emitter and loads it into the middleware
 * @param {EmbedEventEmitter} emitter - the event emitter
 * @return {Object}
 */
export function embedHostLoaded(embedHost) {
    return {
        type: ACTION_USE_EMBED_EVENT_EMITTER,
        embedHost,
    };
}

/**
 * Emits an ad event when an ad companion is rendered
 *
 * @param{event} event - the event name
 * @param{data} data - the payload to be sent with the ad companion
 * @return {Object}
 */
export function adCompanionRendered(event, data = {}) {
    return {
        type: ACTION_AD_COMPANION_EVENT,
        event,
        data,
    };
}

/**
 * Emits a wheel event when a user scrolls their mouse wheel over an embedded player
 *
 * @param {event} event - event data
 * @return {Object}
 */
export function emitWheelEvent(event) {
    return {
        type: ACTION_EMBED_WHEEL_EVENT,
        data: {
            deltaMode: event.deltaMode,
            deltaX: event.deltaX,
            deltaY: event.deltaY,
            shiftKey: event.shiftKey,
        },
    };
}

export function emitFirstPartyAnalyticEvent(event) {
    return {
        type: ACTION_FIRST_PARTY_ANALYTIC_EVENT,
        event: event.name,
        data: event.properties,
    };
}
