export const ACTION_SET_ENVIRONMENT = 'set environment';
export const ACTION_SET_PLAYER_TYPE = 'set player type';
export const ACTION_SET_TWITCH_EVERYWHERE_PARAMS = 'set twitch everywhere params';

export function setEnvironment({ deviceId }) {
    return {
        type: ACTION_SET_ENVIRONMENT,
        deviceId,
    };
}

/**
 * Sets the player type (e.g. popout, embed, frontpage)
 *
 * @param {String} playerType
 * @return {Action}
 */
export function setPlayerType(playerType) {
    return {
        type: ACTION_SET_PLAYER_TYPE,
        playerType,
    };
}

export function setTwitchEverywhereParams(params) {
    return {
        type: ACTION_SET_TWITCH_EVERYWHERE_PARAMS,
        params,
    };
}
