import Errors from 'errors';

export const ACTION_ERROR = 'set error';
export const ACTION_CLEAR_ERROR = 'clear error';

/**
 * Set the error code if any is given
 * @param {Number} error code
 * @return {Object}
 */
export function setError(code) {
    const error = Errors.getError(code);

    return {
        type: ACTION_ERROR,
        code: error.code,
    };
}

/**
 * Clear current error
 * @param {Error} error
 * @return {Object}
 */
export function clearError() {
    return {
        type: ACTION_CLEAR_ERROR,
    };
}
