export const ACTION_USE_EVENT_EMITTER = 'use event emitter';
export const ACTION_EMIT_OPEN_STREAM = 'emit open stream';
export const ACTION_EMIT_PLAYER_READY = 'emit player ready';
export const ACTION_TRANSITION_TO_COLLECTION = 'transition to collection';
export const ACTION_TRANSITION_TO_REC_VOD = 'transition to recommended vod';
export const ACTION_EMIT_FULLSCREEN_CHANGE = 'emit fullscreen change';
export const ACTION_AD_PAUSE = 'emit ad pause';
export const ACTION_AD_PLAY = 'emit ad play';
export const ACTION_AD_PLAYING = 'emit ad playing';

/**
 * Emits an event to webclient when the fullscreen state has changed.
 * @return {Object}
 */
export function emitFullscreenChange() {
    return {
        type: ACTION_EMIT_FULLSCREEN_CHANGE,
    };
}

/**
 * Takes an event emitter and loads it into the middleware
 * @param {EventEmitter} emitter - the event emitter
 * @return {Object}
 */
export function eventEmitterLoaded(emitter) {
    return {
        type: ACTION_USE_EVENT_EMITTER,
        emitter,
    };
}

/**
 * Emits an event to open the stream page from the frontpage
 * @return {Object}
 */
export function emitOpenStream() {
    return {
        type: ACTION_EMIT_OPEN_STREAM,
    };
}

/**
 * Emits an event to web client to redirect to collection
 *
 * @param {String} collectionId
 * @param {String} vodId
 * @return {Object}
 */
export function emitTransitionToCollection(collectionId, vodId) {
    return {
        type: ACTION_TRANSITION_TO_COLLECTION,
        collectionId,
        vodId,
    };
}

/**
 * Emits an event to web client to redirect to vod
 *
 * @param {String} vodId
 * @return {Object}
 */
export function emitTransitionToRecommendedVOD(vodId) {
    return {
        type: ACTION_TRANSITION_TO_REC_VOD,
        vodId,
    };
}

/**
 * Emits a play event when a user starts or resumes ad playback
 *
 * @return {Object}
 */
export function emitAdPlayEvent() {
    return {
        type: ACTION_AD_PLAY,
    };
}

/**
 * Emits a playing event when a user starts or resumes ad playback
 *
 * @return {Object}
 */
export function emitAdPlayingEvent() {
    return {
        type: ACTION_AD_PLAYING,
    };
}

/**
 * Emits a pause event when a user pauses ad playback
 *
 * @return {Object}
 */
export function emitAdPauseEvent() {
    return {
        type: ACTION_AD_PAUSE,
    };
}

/**
 * Emits an event indicating the player is ready for API commands
 * @return {Object}
 */
export function emitPlayerReady() {
    return {
        type: ACTION_EMIT_PLAYER_READY,
    };
}
