import { createClient } from '../experiments';

export const ACTION_SET_EXPERIMENTS = 'set experiments';

/**
 * Set the experiment client in the state store.
 *
 * @param {Minixperiment.Client} experiments
 * @return {Object}
 */
export function setExperiments(experiments) {
    return {
        type: ACTION_SET_EXPERIMENTS,
        experiments,
    };
}

/**
 * Creates a new experiment client for use in the state store.
 *
 * @param {Object} userConfig
 * @return {Object}
 */
export function loadExperiments(userConfig) {
    return setExperiments(createClient(userConfig));
}
