import clone from 'lodash/clone';
export const ACTION_SET_MANIFEST_INFO = 'set manifest info';

function normalizeManifest(extraInfo) {
    const manifest = clone(extraInfo);
    manifest.abs = (manifest.abs === 'true');
    manifest.suppress = (manifest.suppress === 'true');
    // eslint-disable-next-line camelcase
    manifest.broadcast_id = parseInt(manifest.broadcast_id, 10);
    // eslint-disable-next-line camelcase
    manifest.future = (manifest.future === 'true');
    return manifest;
}

/**
 * Sets the twitch-specific info from the master manifest
 * @param {Object} info
 * @return {Object}
 */
export function setManifestInfo(info) {
    return {
        type: ACTION_SET_MANIFEST_INFO,
        info: normalizeManifest(info),
    };
}
