import pick from 'lodash/pick';

export const ACTION_SET_PROVIDED_OPTIONS = 'set provided options';

/**
 * Sets the initial set of options provided to create the video object in order to remember what state to return
 * to if options are temporarily overridden
 *
 * @param {boolean} value of showInfo option provided to init video
 * @return {Object}
 */
export function setPlayerOptions(playerOptions) {
    const selectedOptions = pick(playerOptions, [
        'branding',
        'showInfo',
        'collection',
        'channel',
        'channelId',
        'video',
        'showtheatre',
        'tt_content',
        'tt_medium',
        'force_preroll',
        'force_midroll',
        'force_preroll_id',
        'force_midroll_id',
    ]);

    return {
        type: ACTION_SET_PROVIDED_OPTIONS,
        playerOptions: selectedOptions,
    };
}
