export const ACTION_SET_FULLSCREEN = 'set fullscreen';
export const ACTION_SET_CAN_FULLSCREEN = 'set can fullscreen';
export const ACTION_TOGGLE_FULLSCREEN = 'toggle fullscreen';
export const ACTION_SET_THEATRE_MODE = 'set theatre mode';
export const ACTION_TOGGLE_THEATRE_MODE = 'toggle theatre mode';

/**
 * setFullscreen
 *
 * Toggles fullscreen on/off
 *
 * @param {Boolean} isFullScreen
 * @return {Object}
 */
export function setFullScreen(isFullScreen) {
    return {
        type: ACTION_SET_FULLSCREEN,
        isFullScreen,
    };
}

/**
 * setCanFullScreen
 *
 * On load determine if we can fullscreen or not.
 *
 * @param {Boolean} canFullScreen
 * @return {Object}
 */
export function setCanFullScreen(canFullScreen) {
    return {
        type: ACTION_SET_CAN_FULLSCREEN,
        canFullScreen,
    };
}

export function toggleFullScreen() {
    return {
        type: ACTION_TOGGLE_FULLSCREEN,
    };
}

/**
 * Sets theatre mode
 *
 * @param {Boolean} isTheatreMode
 * @return {Object}
 */
export function setTheatreMode(isTheatreMode) {
    return {
        type: ACTION_SET_THEATRE_MODE,
        isTheatreMode,
    };
}

/**
 * Toggles theatre mode
 *
 * @return {Object}
 */
export function toggleTheatreMode() {
    return {
        type: ACTION_TOGGLE_THEATRE_MODE,
    };
}
