export const ACTION_PUSH_SCREEN = 'push screen';
export const ACTION_POP_SCREEN = 'pop screen';

// screen possible values
/**
 * Defines the mode when the user is being shown a live stream/a VOD
 */
export const CONTENT_SCREEN = 'content';

/**
 * Defines the mode when the user is being shown an IMA advertisement
 */
export const ADVERTISEMENT_SCREEN = 'advertisement';

/**
 * Defines the mode when the user is being shown a stitched advertisement
 */
export const STITCHED_ADVERTISEMENT_SCREEN = 'advertisement-bb';

/**
 * Defines the mode where the user is being shown the storm-warning message
 */
export const STORM_WARNING_SCREEN = 'stormwarning';

/**
 * Defines the mode where the user is being shown the VOD recommendations screen
 */
export const VOD_RECOMMENDATION_SCREEN = 'vodrecommendations';

/**
 * Defines the mode where the user is being shown the subscriber-only VOD screen
 */
export const VOD_RESTRICTED_SCREEN = 'vodrestrictedscreen';

/**
 * Defines the mode where the user is being shown the screen stating the collection is empty
 */
export const COLLECTION_EMPTY_SCREEN = 'collectionemptyscreen';

/**
 * Clip sharing screen
 */
export const CLIP_SHARING_SCREEN = 'clip-sharing-screen';

/**
 * Clip keyboard shortcut screen
 */
export const CLIP_SHORTCUT_SCREEN = 'clip-shortcut-screen';

/**
 * Defines the mode where the user is being shown an error
 */
export const ERROR_SCREEN = 'error';

/**
 * Defines the mode where the user is being shown an unmute overlay
 */
export const UNMUTE_SCREEN = 'unmute';

/**
 * Defines the mode where the user is being shown a subscriber-only quality
 */
export const QUALITY_RESTRICTED_SCREEN = 'qualityrestrictedscreen';

/**
 * Add what screen the viewer is looking at to the screen stack
 *
 * @param {String} screen
 * @return {Object}
 */
export function pushScreen(screen) {
    return {
        type: ACTION_PUSH_SCREEN,
        screen,
    };
}

/**
 * Clear a layer off the screen stack
 *
 * @return {Object}
 */
export function popScreen() {
    return {
        type: ACTION_POP_SCREEN,
    };
}
