import { localStore } from 'util/storage';
import { SITE_MINIPLAYER_ACTION } from '../analytics/analytics';

export const ACTION_INITIALIZE_SETTINGS = 'initialize ui settings';
export const ACTION_SET_PERSISTENCE = 'set persistence';

export function initializeSettings() {
    return {
        type: ACTION_INITIALIZE_SETTINGS,
        settings: {
            persistenceEnabled: localStore.get('persistenceEnabled', true),
        },
    };
}

export function enablePlayerPersistence() {
    return function(dispatch, getState) {
        const { analyticsTracker } = getState();

        analyticsTracker.trackEvent(SITE_MINIPLAYER_ACTION, {
            action: 'persistence_enable',
        });

        localStore.set('persistenceEnabled', true);

        dispatch({
            type: ACTION_SET_PERSISTENCE,
            value: true,
        });
    };
}

export function disablePlayerPersistence() {
    return function(dispatch, getState) {
        const { analyticsTracker } = getState();

        analyticsTracker.trackEvent(SITE_MINIPLAYER_ACTION, {
            action: 'persistence_disable',
        });

        localStore.set('persistenceEnabled', false);

        dispatch({
            type: ACTION_SET_PERSISTENCE,
            value: false,
        });
    };
}
