export const ACTION_DISPLAY_STATS = 'display stats';
export const ACTION_UPDATE_STATS = 'update stats';
export const STATS_UPDATE_INTERVAL = 1000;

/**
 * Updates state with video stats
 * @param {Object} video stats
 * @return {Object}
 */
export function updateStats(videoStats) {
    return {
        type: ACTION_UPDATE_STATS,
        videoStats,
    };
}

/**
 * Set the status of stats being displayed
 * @param {Boolean} stats displayed
 * @return {Object}
 */
export function displayStats(displayed) {
    return {
        type: ACTION_DISPLAY_STATS,
        displayed,
    };
}
