export const ACTION_SET_MINIPLAYER_MODE = 'set miniplayer';
export const ACTION_SHOW_SETTINGS_MENU = 'show settings menu';
export const ACTION_SET_UI_DISPLAY = 'set ui display';
export const ACTION_SHOW_UI_WITH_AUTO_HIDE = 'show ui with auto hide';
export const ACTION_HIDE_UI = 'hide ui';
export const ACTION_HOVERING_ON_UI_ELEMENT = 'hovering on ui element';
export const ACTION_HOVERING_OFF_UI_ELEMENT = 'hovering off ui element';
export const ACTION_SHOW_VOLUME_SLIDER = 'show volume slider';

export const MENU_STATE_NONE = 'none';
export const MENU_STATE_SETTINGS = 'settings';
export const MENU_STATE_EXTENSIONS = 'extensions';

/**
 * Show/hide volume slider
 *
 * @param {Boolean} true/show, false/hide
 * @return {Action}
 */
export function showVolumeSlider(value = true) {
    return {
        type: ACTION_SHOW_VOLUME_SLIDER,
        value: value,
    };
}

export function setMiniPlayerMode(value) {
    return {
        type: ACTION_SET_MINIPLAYER_MODE,
        value: value,
    };
}

export function showMenu(show = MENU_STATE_NONE) {
    return {
        type: ACTION_SHOW_SETTINGS_MENU,
        value: show,
    };
}

export function setUIDisplay(showUI) {
    return {
        type: ACTION_SET_UI_DISPLAY,
        showUI,
    };
}

export function showUIWithAutoHide() {
    return {
        type: ACTION_SHOW_UI_WITH_AUTO_HIDE,
    };
}

export function hideUI() {
    return {
        type: ACTION_HIDE_UI,
    };
}

export function hoveringOnUIElement() {
    return {
        type: ACTION_HOVERING_ON_UI_ELEMENT,
    };
}

export function hoveringOffUIElement() {
    return {
        type: ACTION_HOVERING_OFF_UI_ELEMENT,
    };
}

export function showExtensionsSubmenu(extensionsSubmenu) {
    return {
        type: ACTION_SHOW_SETTINGS_MENU,
        value: MENU_STATE_EXTENSIONS,
        extensionsSubmenu,
    };
}
