import forIn from 'lodash/forIn';

export const ACTION_SET_USHER_PARAMS = 'set usher params';
export const ACTION_SET_USHER_HOST_OVERRIDE = 'set usher host override';
export const USHER_PREFIX = 'usher_';

/**
 * Set the Usher request parameters in the state store.
 *
 * @param {String} playerBackend
 *        denotes backend type
 * @param {Object} options
 *        Options given by the embedder or computed from the page query params.
 * @return {Object}
 */
export function setUsherParams(playerBackend, options) {
    const params = {
        // eslint-disable-next-line camelcase
        player_backend: playerBackend,
    };
    forIn(options, (value, key) => {
        if (key.indexOf(USHER_PREFIX) === 0) {
            const newKey = key.substring(USHER_PREFIX.length);
            params[newKey] = value;
        }
    });
    params.p = Math.floor(Math.random() * 9999999);

    return {
        type: ACTION_SET_USHER_PARAMS,
        params,
    };
}

/**
 * Set an override value for the usher host.
 * @param {String} hostOverride
 * @return {Object}
 */
export function setUsherHostOverride(hostOverride) {
    return {
        type: ACTION_SET_USHER_HOST_OVERRIDE,
        hostOverride,
    };
}
