export const ACTION_LOAD_VIDEO_API = 'load video api';
export const ACTION_VIDEO_API_PLAY = 'video api play content';
export const ACTION_VIDEO_API_PAUSE = 'video api pause content';
export const ACTION_AUTOMATED_PAUSE = 'automated pause content';
export const ACTION_VIDEO_API_MUTE_PLAYER = 'video api mute player';
export const ACTION_VIDEO_API_CHANGE_VOLUME = 'video api change volume';
export const ACTION_VIDEO_API_CHANGE_BACKEND = 'video api change backend';
export const ACTION_VIDEO_API_REPORT_VIDEO_ISSUE = 'video api report video issue';
export const ACTION_VIDEO_API_CHANGE_PLAYBACK_RATE = 'video api change playback rate';
export const ACTION_VIDEO_API_SEEK = 'video api seek';

/**
 * Takes a video instance and loads it into the middleware
 *
 * @param {Video} video - the video instance
 * @return {Object}
 */
export function videoAPILoaded(video) {
    return {
        type: ACTION_LOAD_VIDEO_API,
        video,
    };
}

/**
 * Plays content on the loaded video instance
 *
 * @return {Object}
 */
export function play() {
    return {
        type: ACTION_VIDEO_API_PLAY,
    };
}

/**
 * Pauses content on the loaded video instance
 *
 * @return {Object}
 */
export function pause() {
    return {
        type: ACTION_VIDEO_API_PAUSE,
    };
}

/**
 * Automatically Pauses content on the loaded video instance
 *
 * @return {Object}
 */
export function automatedPause() {
    return {
        type: ACTION_AUTOMATED_PAUSE,
    };
}

/**
 * Mutes the player on the loaded video instance
 *
 * @return {Object}
 */
export function mutePlayer(muted, automated = false) {
    return {
        type: ACTION_VIDEO_API_MUTE_PLAYER,
        muted,
        automated,
    };
}

/**
 * Changes the volume of the player on the loaded video instance
 *
 * @return {Object}
 */
export function changeVolume(volume = 0) {
    return {
        type: ACTION_VIDEO_API_CHANGE_VOLUME,
        volume,
    };
}

/**
 * Changes the backend used by the player
 *
 * @return {Object}
 */
export function changeBackend(backendType) {
    return {
        type: ACTION_VIDEO_API_CHANGE_BACKEND,
        backendType,
    };
}

/**
 * Sends a tracking event for video issue reports
 *
 * @return {Object}
 */
export function submitVideoIssueReport(issueType) {
    return {
        type: ACTION_VIDEO_API_REPORT_VIDEO_ISSUE,
        issueType,
    };
}

/**
 * Changes the playback rate
 *
 * @param {Number} playbackRate
 * @return {Object}
 */
export function changePlaybackRate(playbackRate) {
    return {
        type: ACTION_VIDEO_API_CHANGE_PLAYBACK_RATE,
        playbackRate,
    };
}

/**
 * Seeks to a particular time in the video
 *
 * @param {Number} seekTime
 * @return {Object}
 */
export function seek(seekTime) {
    return {
        type: ACTION_VIDEO_API_SEEK,
        seekTime,
    };
}
