export const ACTION_SET_WATCHPARTY_VOD = 'set watchpartyvod';

/**
 * Dispatches the set watchpartyvod event.
 *
 * @param {Object} pubsubVodInfo An object from pubsub containing the currently playing VOD.
 */
export function updateWatchPartyVod(pubsubVodInfo) {
    return function(dispatch) {
        dispatch({
            type: ACTION_SET_WATCHPARTY_VOD,
            pubsubVodInfo: normalizePubsubVodInfo(pubsubVodInfo),
        });
    };
}

function normalizePubsubVodInfo(vodInfo) {
    return {
        watchPartyId: vodInfo.wp_id,
        vodId: vodInfo.vod_id,
        title: vodInfo.title,
        viewable: vodInfo.viewable,
        broadcastType: vodInfo.broadcast_type,
        incrementViewCountURL: vodInfo.increment_url,
    };
}
