import { TIER_1_EVENTS, VIDEO_PLAYBACK_ERROR } from './events';
import pick from 'lodash/pick';
import { emitFirstPartyAnalyticEvent } from 'actions/embed-event-emitter';

const EVENT_PROPERTY_SCHEMA = Object.freeze({
    [TIER_1_EVENTS.MINUTE_WATCHED]: [
        'time',
        'device_id',
        'play_session_id',
        'customer_id',
        'content_id',
    ],
    [TIER_1_EVENTS.VIDEO_PLAY]: [
        'time',
        'device_id',
        'play_session_id',
        'customer_id',
        'content_id',
        'time_since_load_start',
    ],
    [TIER_1_EVENTS.BUFFER_EMPTY]: [
        'time',
        'device_id',
        'play_session_id',
        'customer_id',
        'content_id',
        'buffer_empty_count',
    ],
    [VIDEO_PLAYBACK_ERROR]: [
        'time',
        'device_id',
        'play_session_id',
        'customer_id',
        'content_id',
        'reason',
        'code',
    ],
});

const FIRST_PARTY_EVENTS_WHITELIST = Object.freeze(Object.keys(EVENT_PROPERTY_SCHEMA));

export class FirstPartyClient {
    constructor(store) {
        this._store = store;
    }

    trackEvents(events) {
        events.
            reduce((firstPartyEvents, { event, properties }) => {
                if (FIRST_PARTY_EVENTS_WHITELIST.includes(event)) {
                    firstPartyEvents.push({
                        name: event,
                        properties: pick(properties, EVENT_PROPERTY_SCHEMA[event]),
                    });
                }

                return firstPartyEvents;
            }, []).
            forEach(e => this._store.dispatch(emitFirstPartyAnalyticEvent(e)));
    }
}
