import extend from 'lodash/extend';
import includes from 'lodash/includes';
import * as Settings from '../settings';
import { b64EncodeUnicode } from './util';
import { stringify } from 'query-string';
/**
 * Mixpanel Client
 * @class
 * @constructor
 *
 * @param {Object} opts
 *        `host`: Mixpanel API host
 *        `token`: Mixpanel API token
 */
export function MixpanelClient(opts) {
    this._host = opts.host;
    this._token = opts.token;
}

/**
 * Send an event to Mixpanel.
 *
 * @param {String} eventName
 * @param {Object} properties
 */
MixpanelClient.prototype.trackEvent = function(eventName, properties) {
    if (includes(Settings.mixpanelIgnore, eventName)) {
        return;
    }

    // Token and time should be added to every request.
    const props = extend({}, properties, {
        token: this._token,
    });

    // Convert the payload to base64 JSON.
    const payload = b64EncodeUnicode(JSON.stringify({
        event: eventName,
        properties: props,
    }));

    const data = stringify({
        data: payload,
        ip: 1,
    });

    fetch(
        `${this._host}/track?${data}`,
        {
            cache: 'no-store',
        }
    );
};

/**
 * Send a group of events to Mixpanel.
 *
 * @param {Array<{event:String, properties:Object}>} events
 */
MixpanelClient.prototype.trackEvents = function(events) {
    events.forEach(function(event) {
        this.trackEvent(event.event, event.properties);
    }, this);
};
