import { initMoatTracking } from './init-moat-tracking.js';
import extend from 'lodash/extend';

/**
 * Wrapper class to hide code to load Moat HTML5 player metrics.
 *
 * @param adContainer DOM element container which will display ad
 * @param moatTracking function to call to initalize Moat tracking; included for testing
 */
export class MoatAnalytics {
    constructor(adContainer, store) {
        this._adContainer = adContainer;
        this._moatTracking = initMoatTracking;
        this._google = store.getState().window.google;
    }

    trackAd(adsManager, adRequestContext) {
        const slicer = buildSlicer(adRequestContext);
        const viewabilityIds = {
            partnerCode: 'twitchvpaid2756206246',
            viewMode: this._google.ima.ViewMode.NORMAL,
            slicer1: 'www.twitch.tv',
            slicer2: slicer,
        };
        const ids = extend(viewabilityIds, buildAudienceVerification(adRequestContext));

        try {
            this._moatTracking(adsManager, ids, this._adContainer);
        } catch (e) {
            // eslint-disable-next-line no-console
            console.error('Moat tracking failed: ', e);
        }
    }
}

/**
 * Build slicer values required by MOAT script viewability classification
 */
export function buildSlicer(adRequestContext) {
    let slicer = 'unknown';
    if (adRequestContext && adRequestContext.channel) {
        slicer = adRequestContext.channel;
    }

    if (adRequestContext && adRequestContext.game) {
        slicer = `${slicer} + ${adRequestContext.game}`;
    }

    return slicer;
}

/**
 * Add values used for MOAT Audience Verification (age/demo stats by game/channel)
 */
export function buildAudienceVerification(adRequestContext) {
    return {
        zMoatChannel: adRequestContext.channel,
        zMoatChannelID: adRequestContext.channelId,
        zMoatGame: adRequestContext.game,
    };
}
