const SENTINEL_CLIENT_ID = 'qFEaZsFQnwEdUIs';
const SENTINEL_SCRIPT_URL = '//d1xfq2052q7thw.cloudfront.net/1.7.461.js';

/**
 * Sentinel is a library by Sourcepoint to detect adblock.
 * More docs attached here: https://twitchtv.atlassian.net/secure/attachment/23734/SourcepointAnalyticsDisplay_v1.4.pdf
 */
export function getSentinel(windowObj) {
    // Our Client ID
    // eslint-disable-next-line camelcase, no-param-reassign
    windowObj.sp_cid = SENTINEL_CLIENT_ID;

    // Imitating Twitch.sentinel object
    const sentinel = {
        detect: {},
    };

    let blockingFn;
    let nonBlockingFn;

    const sentinelPromise = new Promise(function(resolve, reject) {
        // Load and evaluate the Sentinel Script
        const $scriptEl = windowObj.document.createElement('script');
        windowObj.document.body.appendChild($scriptEl);
        $scriptEl.onerror = reject;
        $scriptEl.async = true;
        $scriptEl.src = SENTINEL_SCRIPT_URL;

        // If the script is not loaded and evaluated in 2 seconds, reject
        windowObj.setTimeout(reject, 2000);

        blockingFn = () => resolve(true);
        nonBlockingFn = () => resolve(false);
        windowObj.document.addEventListener('sp.blocking', blockingFn);
        windowObj.document.addEventListener('sp.not_blocking', nonBlockingFn);
    });

    return sentinelPromise.then(null, () => 'unknown').then(result => {
        sentinel.detect._result = result;
        // eslint-disable-next-line no-param-reassign
        windowObj.Twitch.sentinel = sentinel;
        windowObj.document.removeEventListener('sp.blocking', blockingFn);
        windowObj.document.removeEventListener('sp.not_blocking', nonBlockingFn);
        return result;
    });
}
