import {
    REBROADCAST_TYPE, BROADCAST_PLATFORM_WATCH_PARTY,
    BROADCAST_PLATFORM_WATCH_PARTY_RERUN,
    BROADCAST_PLATFORM_WATCH_PARTY_PREMIERE } from './analytics';

export function getContentInfo(broadcasterSoftware) {
    let live = true;
    let contentMode = 'live';
    if ((broadcasterSoftware === BROADCAST_PLATFORM_WATCH_PARTY) ||
        (broadcasterSoftware === BROADCAST_PLATFORM_WATCH_PARTY_PREMIERE) ||
        (broadcasterSoftware === BROADCAST_PLATFORM_WATCH_PARTY_RERUN)) {
        contentMode = 'vodcast';
    } else if (broadcasterSoftware === REBROADCAST_TYPE) {
        contentMode = 'vod';
        live = false;
    }

    return {
        live,
        contentMode,
    };
}

/* This solves the issue of trying to call `btoa` on a string with characters outside of the 8-bit ASCII set.
 * Copied from https://developer.mozilla.org/en-US/docs/Web/API/WindowBase64/Base64_encoding_and_decoding
 */
export function b64EncodeUnicode(str) {
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function(match, p1) {
        return String.fromCharCode(`0x${p1}`);
    }));
}
