/* eslint-disable no-unused-vars, no-undef */
// Empty backend used to define the Backend "interface".
//
// All methods are defined in the same order as the spec:
// http://dev.w3.org/html5/spec-author-view/video.html#mediaevents

import EventEmitter from 'event-emitter';

export const BACKEND_BLANK_ERROR = 'Blank Backend Error';
export const BACKEND_BLANK_TYPE = 'blank';

export function BackendBlank() {
    'use strict';
    var self = this;

    var events = new EventEmitter();

    self.attach = function(element) {
        // unimplemented
    };

    self.destroy = function() {
        // unimplemented
    };

    self.getVersion = function() {
        return '';
    };

    self.addEventListener = function(name, func) {
        events.on(name, func);
    };

    self.removeEventListener = function(name, func) {
        events.off(name, func);
    };

    self.getError = function() {
        return BACKEND_BLANK_ERROR;
    };

    self.getSrc = function() {
        // unimplemented
    };

    self.getStats = function() {
        return {};
    };

    self.setSrc = function(value) {
        // unimplemented
    };

    self.getNetworkState = function() {
        // unimplemented
    };

    self.getBuffered = function() {
        // unimplemented
    };

    self.load = function() {
        // unimplemented
    };

    self.getReadyState = function() {
        // unimplemented
    };

    self.getSeeking = function() {
        // unimplemented
    };

    self.getCurrentTime = function() {
        // unimplemented
    };

    self.setCurrentTime = function(value) {
        // unimplemented
    };

    self.getDuration = function() {
        // unimplemented
    };

    self.getPaused = function() {
        // unimplemented
    };

    self.getPlaybackRate = function() {
        // unimplemented
    };

    self.setPlaybackRate = function(value) {
        // unimplemented
    };

    self.getPlayed = function() {
        // unimplemented
    };

    self.getEnded = function() {
        // unimplemented
    };

    self.getAutoplay = function() {
        // unimplemented
    };

    self.setLoop = function(value) {
        // unimplemented
    };

    self.play = function() {
        // unimplemented
    };

    self.pause = function() {
        // unimplemented
    };

    self.getControls = function() {
        // unimplemented
    };

    self.setControls = function(value) {
        // unimplemented
    };

    self.getVolume = function() {
        // unimplemented
    };

    self.setVolume = function(value) {
        // unimplemented
    };

    self.getMuted = function() {
        // unimplemented
    };

    self.setMuted = function(value) {
        // unimplemented
    };

    self.getQuality = function() {
        // unimplemented
    };

    self.setQuality = function(value) {
        // unimplemented
    };

    self.getQualities = function() {
        return [];
    };

    self.setChannel = function(value, stream) {
        // unimplemented
    };

    self.elapsedTime = function() {
        // unimplemented
    };

    self.setVideo = function(value, stream) {
        // unimplemented
    };

    self.getVideoInfo = function() {
        // unimplemented
    };

    self.getCaption = function() {
        // unimplemented
    };

    self.getBackend = function() {
        return BACKEND_BLANK_TYPE;
    };

    self.absAvailable = function() {
    };
}
