
/**
 * The user agent begins looking for media data, as part of the resource selection algorithm.
 *
 * networkState equals NETWORK_LOADING
 */
export const LOADSTART = 'loadstart';

/**
 * An error occurs while fetching the media data or the type of the resource is not supported media format.
 *
 * error is an object with the code MEDIA_ERR_NETWORK or higher. networkState equals either NETWORK_EMPTY
 * or NETWORK_IDLE, depending on when the download was aborted.
 */
export const ERROR = 'error';

/**
 * The user agent has just determined the duration and dimensions of the media resource and the
 * text tracks are ready.
 *
 * readyState is newly equal to HAVE_METADATA or greater for the first time.
 */
export const LOADED_METADATA = 'loadedmetadata';

/**
 * The user agent can resume playback of the media data, but estimates that if playback were
 * to be started now, the media resource could not be rendered at the current playback rate
 * up to its end without having to stop for further buffering of content.
 *
 * readyState newly increased to HAVE_FUTURE_DATA or greater.
 */
export const CAN_PLAY = 'canplay';

/**
 * This event fires once the entire MP4 has been loaded
 */
export const CAN_PLAY_THROUGH = 'canplaythrough';

/**
 * Playback is ready to start after having been paused or delayed due to lack of media data.
 *
 * readyState is newly equal to or greater than HAVE_FUTURE_DATA and paused is false, or paused
 * is newly false and readyState is equal to or greater than HAVE_FUTURE_DATA. Even if this event
 * fires, the element might still not be potentially playing, e.g. if the element is blocked on
 * its media controller (e.g. because the current media controller is paused, or another slaved
 * media element is stalled somehow, or because the media resource has no data corresponding to
 * the media controller position), or the element is paused for user interaction or paused for
 * in-band content.
 */
export const PLAYING = 'playing';

/**
 * Playback has stopped because the next frame is not available, but the user agent expects that frame
 * to become available in due course.
 *
 * readyState is equal to or less than HAVE_CURRENT_DATA, and paused is false. Either seeking is
 * true, or the current playback position is not contained in any of the ranges in buffered.
 * It is possible for playback to stop for other reasons without paused being false, but those
 * reasons do not fire this event (and when those situations resolve, a separate playing event is
 * not fired either): e.g. the element is newly blocked on its media controller, or playback ended,
 * or playback stopped due to errors, or the element has paused for user interaction or paused for
 * in-band content.
 */
export const WAITING = 'waiting';

/**
 * The seeking IDL attribute changed to true, and the user agent has started seeking to a new position.
 */
export const SEEKING = 'seeking';

/**
 * The seeking IDL attribute changed to false after the current playback position was changed.
 */
export const SEEKED = 'seeked';

/**
 * Playback has stopped because the end of the media resource was reached.
 *
 * currentTime equals the end of the media resource; ended is true.
 */
export const ENDED = 'ended';

/**
 * The metadata has loaded or changed, indicating a change in duration of the media.
 * This is sent, for example, when the media has loaded enough that the duration is known.
 */
export const DURATION_CHANGE = 'durationchange';

/**
 * The current playback position changed as part of normal playback or in an especially
 * interesting way, for example discontinuously.
 */
export const TIME_UPDATE = 'timeupdate';

/**
 * The element is no longer paused. Fired after the play() method has returned, or when the
 * autoplay attribute has caused playback to begin.
 *
 * paused is newly false.
 */
export const PLAY = 'play';

/**
 * The element has been paused. Fired after the pause() method has returned.
 *
 * paused is newly true.
 */
export const PAUSE = 'pause';

/**
 * Either the volume attribute or the muted attribute has changed. Fired after the relevant attribute's
 * setter has returned.
 */
export const VOLUME_CHANGE = 'volumechange';

/**
 * Raised when the value of `playbackRate` changes.
 */
export const RATE_CHANGE = 'ratechange';

/**
 * The loadeddata event is fired when the first frame of the media has finished loading.
 */
export const LOADED_DATA = 'loadeddata';

/**
 * The stalled event is fired when the user agent is trying to fetch media data,
   but data is unexpectedly not forthcoming.
 */
export const STALLED = 'stalled';

/**
 * The user agent stops fetching the media data before it is completely downloaded, but not due to an error.
 */
export const ABORT = 'abort';
