
/**
 * Marks video player initialization. Should be fired whenever a new
 * player instance is intialized, and marks the beginning of every
 * video session, even for sessions that don’t make it to video-play.
 */
export const PLAYER_INIT = 'init';

/**
 * Marks when the player is showing content
 */
export const CONTENT_SHOWING = 'contentShowing';

/**
 * Defines the value of the playback event to described when the playback
 * statistics has updated.
 */
export const PLAYBACK_STATISTICS = 'playbackStatistics';

/**
 * Defines the value of the playback event to describe when the
 * requested format requires a chansub
 */
export const CHANSUB_REQUIRED = 'chansubRequired';

/**
 * Defines the value of the playback event to describe when requested
 * video content has failed to play.
 */
export const VIDEO_FAILURE = 'videoFailure';

/**
 * Defines the value of the playback event to describe when the video
 * format list is aquired.
 */
export const FORMATS = 'videoFormats';

/**
 * Defines the event when abs requests a format change
 */
export const ABS_STREAM_FORMAT_CHANGE = 'abs_stream_format_change';

/**
 * Defines the value of the playback event to describe when the video
 * format change has completed.
 */
export const FORMAT_CHANGED = 'videoFormatChanged';

/**
 * The time indicated by the element's currentTime attribute has changed.
 */
export const TIME_CHANGE = 'timeChange';

/**
 * Defines the value of the playback event to describe when a videos
 * playback time has changed.
 */
export const BUFFER_CHANGE = 'bufferChange';

/**
 * Defines the value of the video event emitted when an HLS stream
 * switches to a new segment.
 */
export const SEGMENT_CHANGE = 'segmentchange';

/**
 * Defines the value of the playback event to describe when an usher
 * request fails to return data.
 */
export const USHER_FAIL_ERROR = 'usherFail';

/**
 * Defines the value of the playback event to describe when the
 * video stream captions data has been updated.
 */
export const CAPTION_UPDATE = 'captions';

/**
 * Defines the value of the playback event to describe when an attempt
 * to seek has failed.
 */
export const SEEK_FAILED = 'seekfailed';

/**
 * Event emitted from backend when ABS requests a change in playback quality
 */
export const VARIANT_SWITCH_REQUESTED = 'variantSwitchRequested';

/**
 * The count of active viewers has been altered.
 */
export const VIEWERS_CHANGE = 'viewerschange';

/**
 * Defines the value of the playback event to describe when the
 * live video stream has loaded.
 */
export const STREAM_LOADED = 'streamLoaded';

/**
 * Defines the value of the playback event to describe when the
 * VOD video stream has loaded.
 */
export const VIDEO_LOADED = 'videoLoaded';

/**
 * Defines the value of the playback event to describe when the
 * video stream has been paused.
 */
export const VIDEO_PAUSED = 'videoPaused';

/**
 * Defines the value of the playback event to describe when the
 * video stream has change its quality of playback.
 */
export const QUALITY_CHANGE = 'qualitychange';

/**
 * Defines the value of the playback event to describe when the
 * content stream channel goes online.
 */
export const ONLINE = 'online';

/**
 * Defines the value of the playback event to describe when the
 * content stream channel goes offline.
 */
export const OFFLINE = 'offline';

/**
 * Defines the value of the playback event to describe when the
 * video stream playback is restricted.
 */
export const RESTRICTED = 'restricted';

/**
 * "Happens when chromecast...does stuff" ~srabin 2016.06.06
 */
export const CASTING_CHANGE = 'castingchange';

/**
 * Defines the value of the playback event to describe when the
 * user clicks the Theater Mode button.
 */
export const THEATRE_CHANGE = 'theatrechange';

/**
 * Defines the value of the playback event to describe when the
 * we're requesting a midroll
 */
export const MIDROLL_REQUESTED = 'midrollrequested';

/**
 * Defines the event that is fired with extra info from the manifest
 */
export const MANIFEST_EXTRA_INFO = 'manifestExtraInfo';

/**
 * Defines the event that is fired when a page transition is needed
 * Intended to be fired as a consequence of clicking on a VOD in the site player
 * in the context of a collection.
 */
export const TRANSITION_TO_COLLECTION_VOD = 'transitionToCollectionVod';

/**
 * Defines the event that is fired when a page transition is needed
 * Intended to be fired as a consequence of clicking on a VOD in the site player
 * from in-player recommendations.
 */
export const TRANSITION_TO_RECOMMENDED_VOD = 'transitionToRecommendedVod';

/**
 * Defines the event that is fired when a stitched ad is playing
 */
export const STITCHED_AD_START = 'stitchedadstart';

/**
 * Defines the event that is fired when a stitched ad ends
 */
export const STITCHED_AD_END = 'stitchedadend';

/**
 * Defines the event that fires when the miniplayer enable/disable setting is toggled
 */
export const PERSISTENT_PLAYER_TOGGLE = 'persistentPlayerEnableToggle';

/**
 * Defines the event that fires when stats are updated after being enabled through
 * the video api.
 */
export const STATS_UPDATE = 'statsupdate';

/**
 * Defines the event that prompts webclient to open the login modal
 */
export const PROMPT_LOGIN_MODAL = 'prompt login modal';

/**
 * Defines the event that prompts web-client to transition to a stream from the frontpage
 */
export const OPEN_STREAM = 'openStream';

/**
 * Defines the event that fires when the player is ready to be interacted with via API
 */
export const PLAYER_READY = 'ready';
