import extend from 'lodash/extend';

const basePreset = {
    fontSize: 20,
    font: 'prop-sans-serif',
    fontOpacity: 'solid',
    alignment: 'left',
    edge: 'none',
    verticalPosition: 'bottom',
    backgroundColorName: 'black',
    backgroundOpacity: 'solid',
    windowColorName: 'transparent',
    windowOpacity: 'solid',
    fontUnderline: 'none',
    fontBold: 'none',
    fontItalic: 'none',
};

const transBasePreset = extend({}, basePreset, {
    backgroundColorName: 'black',
    backgroundOpacity: 'translucent',
});

export const presetMap = {
    'white-on-black': extend({}, basePreset, {
        fontColorName: 'white',
    }),
    'cyan-on-black': extend({}, basePreset, {
        fontColorName: 'cyan',
    }),
    'yellow-on-black': extend({}, basePreset, {
        fontColorName: 'yellow',
    }),
    'lime-on-black': extend({}, basePreset, {
        fontColorName: 'green',
    }),
    'magenta-on-black': extend({}, basePreset, {
        fontColorName: 'magenta',
    }),
    'white-on-trans-black': extend({}, transBasePreset, {
        fontColorName: 'white',
    }),
    'cyan-on-trans-black': extend({}, transBasePreset, {
        fontColorName: 'cyan',
    }),
    'yellow-on-trans-black': extend({}, transBasePreset, {
        fontColorName: 'yellow',
    }),
    'lime-on-trans-black': extend({}, transBasePreset, {
        fontColorName: 'green',
    }),
    'magenta-on-trans-black': extend({}, transBasePreset, {
        fontColorName: 'magenta',
    }),
    'black-on-white': extend({}, basePreset, {
        backgroundColorName: 'white',
        fontColorName: 'black',
    }),
};

export const fontMap = {
    'mono-serif': {
        fontFamily: '"Courier New", Courier, "Nimbus Mono L", "Cutive Mono", monospace',
        fontVariant: 'normal',
    },
    'prop-serif': {
        fontFamily: '"Times New Roman", Times, Georgia, Cambria, "PT Serif Caption", serif',
        fontVariant: 'normal',
    },
    'mono-sans-serif': {
        fontFamily: '"Deja Vu Sans Mono", "Lucida Console", Monaco, Consolas, "PT Mono", monospace',
        fontVariant: 'normal',
    },
    'prop-sans-serif': {
        fontFamily: 'Verdana, Arial, Helvetica, "PT Sans Caption", sans-serif',
        fontVariant: 'normal',
    },
    casual: {
        fontFamily: '"Comic Sans MS", Impact, Handlee, fantasy',
        fontVariant: 'normal',
    },
    cursive: {
        fontFamily: '"Monotype Corsiva", "URW Chancery L", "Apple Chancery", "Dancing Script", cursive',
        fontVariant: 'normal',
    },
    'small-capitals': {
        fontFamily: '"Arial Unicode Ms", Arial, Helvetica, Verdana, "Marcellus SC", sans-serif',
        fontVariant: 'small-caps',
    },
};

export const opacityMap = {
    semiTransparent: {
        opacityValue: 0.3,
        animation: 'none',
    },
    transparent: {
        opacityValue: 0,
        animation: 'none',
    },
    translucent: {
        opacityValue: 0.6,
        animation: 'none',
    },
    solid: {
        opacityValue: 1,
        animation: 'none',
    },
    flashing: {
        opacityValue: 1,
        animation: 'blink .75s linear infinite',
    },
};

export const edgeMap = {
    depressed: {
        textShadow: '-1px -1px 2px #000',
    },
    uniform: {
        textShadow: '-2px -2px 0 #000, -2px 2px 0 #000, -2px 0 0 #000, 2px -2px 0 #000,' +
                    ' 2px 2px 0 #000, 2px 0 0 #000, 0 -2px 0 #000, 0 2px 0 #000',
    },
    drop: {
        textShadow: '0 2px 5px #000',
    },
    raised: {
        textShadow: '1px 1px 2px #000',
    },
    none: {
        textShadow: 'none',
    },
};

export const alignmentMap = {
    left: {
        textAlign: 'left',
    },
    center: {
        textAlign: 'center',
    },
    right: {
        textAlign: 'right',
    },
};

export const fontUnderlineMap = {
    underline: {
        textDecoration: 'underline',
    },
    none: {
        textDecoration: 'none',
    },
};

export const fontItalicMap = {
    italic: {
        fontStyle: 'italic',
    },
    none: {
        fontStyle: 'normal',
    },
};

export const fontBoldMap = {
    bold: {
        fontWeight: 'bold',
    },
    none: {
        fontWeight: 'normal',
    },
};

export const verticalPositionMap = {
    top: {
        top: '18%',
        bottom: 'auto',
    },
    bottom: {
        top: 'auto',
        bottom: '10%',
    },
};

/**
 *
 * @param {String} rgbColor in format '0,0,0'
 * @param {String} opacity in format '0.1'
 * @return {String} Color string combining RGB values with opacity
 */

export function calculateRGBA(rgbColor, opacity) {
    if (rgbColor === 'transparent') return 'transparent';
    return `rgba(${rgbColor},${opacity})`;
}

export const fontColorMap = {
    black: { fontColorValue: '0,0,0' },
    white: { fontColorValue: '255,255,255' },
    red: { fontColorValue: '255,0,0' },
    green: { fontColorValue: '0,255,0' },
    blue: { fontColorValue: '0,0,255' },
    yellow: { fontColorValue: '255,255,0' },
    magenta: { fontColorValue: '255,0,255' },
    cyan: { fontColorValue: '0,255,255' },
};

export const backgroundColorMap = {
    black: { backgroundColorValue: '0,0,0' },
    white: { backgroundColorValue: '255,255,255' },
    red: { backgroundColorValue: '255,0,0' },
    green: { backgroundColorValue: '0,255,0' },
    blue: { backgroundColorValue: '0,0,255' },
    yellow: { backgroundColorValue: '255,255,0' },
    magenta: { backgroundColorValue: '255,0,255' },
    cyan: { backgroundColorValue: '0,255,255' },
    lightgray: { backgroundColorValue: '199,199,199' },
    gray: { backgroundColorValue: '145,145,145' },
    darkgray: { backgroundColorValue: '91,91,91' },
    transparent: { backgroundColorValue: 'transparent' },
};

export const fontSizeMap = {
    increment: 5,
    decrement: -5,
    max: 40,
    min: 10,
};
