import mapValues from 'lodash/mapValues';
import find from 'lodash/find';
import ERROR_METADATA from 'error-metadata';

const ERROR_CODES = Object.freeze(mapValues(ERROR_METADATA, ({ code }) => code));

export default class Errors {
    // eslint-disable-next-line new-cap
    static get CODES() {
        return ERROR_CODES;
    }

    static getError(code) {
        const error = find(ERROR_METADATA, { code });

        if (error) {
            return error;
        }

        throw new Error(`Invalid error code ${code}`);
    }

    static getMessage(code) {
        const { message } = Errors.getError(code);
        return message;
    }
}
