import * as AnalyticsTrackerActions from 'actions/analytics-tracker';
import { NullAnalyticsTracker } from 'defaults/null-analytics-tracker';

const NULL_ANALYTICS_TRACKER = new NullAnalyticsTracker();

/**
 * Creates Analytics Tracker middleware with a supplied null tracker object
 *
 * @param {Object} [tracker=NULL_ANALYTICS_TRACKER] - the analytics tracker to use
 */
export function createAnalyticsTrackerMiddleware(tracker = NULL_ANALYTICS_TRACKER) {
    // eslint-disable-next-line no-unused-vars
    return store => next => {
        let _tracker = tracker;

        return action => {
            switch (action.type) {
            case AnalyticsTrackerActions.ACTION_SET_ANALYTICS_TRACKER:
                _tracker = action.tracker;
                break;
            case AnalyticsTrackerActions.ACTION_TRACK_EVENT:
                _tracker.trackEvent(action.eventName, action.eventProperties);
                break;
            }

            next(action);
        };
    };
}
