import * as EmbedEventEmitterActions from 'actions/embed-event-emitter';
import { ACTION_EMIT_PLAYER_READY, ACTION_TRANSITION_TO_COLLECTION,
         ACTION_TRANSITION_TO_REC_VOD } from 'actions/event-emitter';
import { NullEmbedHost } from 'defaults/null-embed-host';
import { ACTION_UPDATE_STATS } from 'actions/stats';
import { ACTION_PLAYER_SEEKED } from 'actions/playback';

const NULL_EMBED_HOST = new NullEmbedHost();

/**
 * Creates Embed Event Emitter middleware with a supplied null embed event emitter object
 *
 * @param {Object} [embedEventEmittter=NULL_EMBED_EVENT_EMITTER] - the event emitter to use
*/
export function createEmbedHostMiddleware(embedHost = NULL_EMBED_HOST) {
    // eslint-disable-next-line no-unused-vars
    return store => next => {
        let _embedHost = embedHost;

        return action => {
            switch (action.type) {
            case EmbedEventEmitterActions.ACTION_USE_EMBED_EVENT_EMITTER:
                _embedHost = action.embedHost;
                break;
            case EmbedEventEmitterActions.ACTION_AD_COMPANION_EVENT:
                _embedHost._sendAdCompanionEvent(action.event, action.data);
                break;
            case EmbedEventEmitterActions.ACTION_EMBED_WHEEL_EVENT:
                _embedHost._emitWheelEvent(action.data);
                break;
            case EmbedEventEmitterActions.ACTION_FIRST_PARTY_ANALYTIC_EVENT:
                _embedHost._sendFirstPartyAnalyticEvent(action.event, action.data);
                break;
            case ACTION_TRANSITION_TO_COLLECTION:
                _embedHost._sendTransitionToCollectionEvent({
                    vodId: action.vodId,
                    collectionId: action.collectionId,
                });
                break;
            case ACTION_TRANSITION_TO_REC_VOD:
                _embedHost._sendTransitionToRecommendedVodEvent({
                    vodId: action.vodId,
                });
                break;
            case ACTION_UPDATE_STATS:
                _embedHost._sendStatsUpdateEvent();
                break;
            case ACTION_EMIT_PLAYER_READY:
                _embedHost._sendReadyEvent();
                break;
            case ACTION_PLAYER_SEEKED:
                _embedHost._sendSeekedEvent(action.currentTime);
                break;
            }

            next(action);
        };
    };
}
