import * as VideoAPIActions from 'actions/video-api';
import { ACTION_START_CASTING, ACTION_STOP_CASTING } from 'actions/chromecast';

/**
 * Creates video API middleware
 */
export function createVideoApiMiddleware() {
    // eslint-disable-next-line no-unused-vars
    return store => next => {
        let _videoAPIPromiseResolve;
        const _videoInstance = new Promise(function(resolve) {
            _videoAPIPromiseResolve = resolve;
        });

        // eslint-disable-next-line complexity
        return action => {
            switch (action.type) {
            case VideoAPIActions.ACTION_LOAD_VIDEO_API:
                _videoAPIPromiseResolve(action.video);
                break;
            case VideoAPIActions.ACTION_VIDEO_API_PLAY:
                _videoInstance.then(api => api.play());
                break;
            case VideoAPIActions.ACTION_VIDEO_API_PAUSE:
                _videoInstance.then(api => api.pause());
                break;
            case VideoAPIActions.ACTION_AUTOMATED_PAUSE:
                _videoInstance.then(api => api.automatedPause());
                break;
            case VideoAPIActions.ACTION_VIDEO_API_MUTE_PLAYER:
                _videoInstance.then(api => api.setMuted(action.muted, action.automated));
                break;
            case VideoAPIActions.ACTION_VIDEO_API_CHANGE_VOLUME:
                _videoInstance.then(api => api.setVolume(action.volume));
                break;
            case VideoAPIActions.ACTION_VIDEO_API_REPORT_VIDEO_ISSUE:
                _videoInstance.then(api => api.submitVideoIssueReport(action.issueType));
                break;
            case VideoAPIActions.ACTION_VIDEO_API_CHANGE_BACKEND:
                _videoInstance.then(api => api.setBackend(action.backendType));
                break;
            case VideoAPIActions.ACTION_VIDEO_API_CHANGE_PLAYBACK_RATE:
                _videoInstance.then(api => api.setPlaybackRate(action.playbackRate));
                break;
            case VideoAPIActions.ACTION_VIDEO_API_SEEK:
                _videoInstance.then(api => api.setCurrentTime(action.seekTime));
                break;
            case ACTION_START_CASTING:
                _videoInstance.then(api => api.startCast());
                break;
            case ACTION_STOP_CASTING:
                _videoInstance.then(api => api.stopCast());
                break;
            }

            next(action);
        };
    };
}
