import union from 'lodash/union';
import { parseUri } from './util/parseuri';
import * as AdEvents from './ads/advertisement-event';
import * as TwitchEvents from './backend/events/twitch-event';
import * as MediaEvents from './backend/events/media-event';
import { FULLSCREEN_CHANGE } from './util/fullscreen';

// This is imported from a util file used in the embed player because exporting it out of settings.js would
// make the embed bundle include settings.js, which makes it 3x bigger than it needs to be.
import { twitchDomain } from 'util/twitch-embed';

const TEST_PLAYER_AUTHORITY = 'testplayer.twitch.tv';

export const TWITCH_SIGNUP_URL = 'https://www.twitch.tv/signup';
export const DEFAULT_AVATAR_URL = 'https://static-cdn.jtvnw.net/jtv_user_pictures/xarth/404_user_70x70.png';
export const domain = twitchDomain;
export const twitchHost = '//www.twitch.tv';
export const apiHost = 'https://api.twitch.tv';
export const usherHost = 'https://usher.ttvnw.net';
export const valveApiHost = `${apiHost}/steam/watching`;
export const playerHost = (function() {
    // eslint-disable-next-line max-len
    // http://stackoverflow.com/questions/403967/how-may-i-reference-the-script-tag-that-loaded-the-currently-executing-script
    // Works on all modern browsers except IE...
    var script = document.currentScript;
    var scripts = document.getElementsByTagName('script');

    if (!script) {
        // Find any scripts ending with 'player.js' or 'player.*.js'
        var matches = Array.prototype.filter.call(scripts, function(s) {
            return s.src && s.src.match(/player(?:\.\w+)?\.js$/i);
        });

        // If there are duplicates, we are very confused.
        if (matches.length === 1) {
            script = matches[0];
        } else {
            // Use the last script added to the page instead.
            // This will be our script UNLESS async was used (rare).
            script = scripts[scripts.length - 1];
        }
    }

    const uri = parseUri(script.src);
    // Special case the test environment; for those envs, we need to preserve
    // the non-root path to the player by inspecting the player.js script for
    // the branch name associated with the player.
    if (uri.authority === TEST_PLAYER_AUTHORITY) {
        const branchName = uri.path.split('/').slice(1, -2).join('/');
        return `${uri.protocol}://${uri.authority}/${branchName}`;
    }

    return `${uri.protocol}://${uri.authority}`;
})();

// Tracking
export const mixpanelHost = '//api.mixpanel.com';
export const mixpanelToken = '809576468572134f909dffa6bd0dcfcf';
// QA mixpanel token; should only be enabled manually.
// export const mixpanelToken = '3857da20a3c2b03bb017825a6d1bce3e';
export const mixpanelIgnore = [
    'abs_stream_format_change',
    'minute-buffered',
    'x_untrusted_video_init', // TODO Remove these events.
    'x_untrusted_video-play',
    'x_untrusted_minute-watched',
    'x_untrusted_buffer-empty',
    'x_untrusted_buffer-refill',
    'network_profile',
    'video_pause',
];

// Spade hosts *must* be protocol relative for IE9's XDR to work correctly. XDR
// cannot make cross-protocol requests; only cross-domain is allowed.
export const untrustedSpadeHost = '//spade.twitch.tv';
export const spadeIgnore = [];

export const countessHost = '//countess.twitch.tv';

export const gamePath = `${twitchHost}/directory/game`;

// Default popout size. 480p
export const popoutSize = {
    width: 853,
    height: 480,
};

export const chromecastId = 'B3DCF968';

// Show the quality change animation for 6 seconds.
export const qualityChangeDuration = 6000;

// Show the controls initially for 8 seconds.
export const initialControlsDelay = 8000; // ms

// Only show the controls for 5 seconds when hovering.
export const hoverControlsDelay = 5000; // ms

// http://dev.w3.org/html5/spec-author-view/video.html#mediaevents
export const mediaEvents = [
    MediaEvents.LOADSTART,
    MediaEvents.ABORT,
    MediaEvents.ERROR,
    MediaEvents.STALLED,
    MediaEvents.LOADED_METADATA,
    MediaEvents.LOADED_DATA,
    MediaEvents.CAN_PLAY,
    MediaEvents.CAN_PLAY_THROUGH,
    MediaEvents.PLAYING,
    MediaEvents.WAITING,
    MediaEvents.SEEKING,
    MediaEvents.SEEKED,
    MediaEvents.ENDED,
    MediaEvents.DURATION_CHANGE,
    MediaEvents.TIME_UPDATE,
    MediaEvents.PLAY,
    MediaEvents.PAUSE,
    MediaEvents.VOLUME_CHANGE,
    MediaEvents.RATE_CHANGE,
];

export const customEvents = [
    'usherfail',
    AdEvents.AD_END,
    AdEvents.AD_START,
    AdEvents.COMPANION_RENDERED,
    AdEvents.AD_IMPRESSION,
    AdEvents.AD_IMPRESSION_COMPLETE,
    FULLSCREEN_CHANGE,
    TwitchEvents.BUFFER_CHANGE,
    TwitchEvents.CAPTION_UPDATE,
    TwitchEvents.CASTING_CHANGE,
    TwitchEvents.MANIFEST_EXTRA_INFO,
    TwitchEvents.OFFLINE,
    TwitchEvents.ONLINE,
    TwitchEvents.PLAYER_INIT,
    TwitchEvents.CONTENT_SHOWING,
    TwitchEvents.OPEN_STREAM,
    TwitchEvents.QUALITY_CHANGE,
    TwitchEvents.RESTRICTED,
    TwitchEvents.SEGMENT_CHANGE,
    TwitchEvents.THEATRE_CHANGE,
    TwitchEvents.TRANSITION_TO_COLLECTION_VOD,
    TwitchEvents.TRANSITION_TO_RECOMMENDED_VOD,
    TwitchEvents.VIEWERS_CHANGE,
    TwitchEvents.ABS_STREAM_FORMAT_CHANGE,
    TwitchEvents.PERSISTENT_PLAYER_TOGGLE,
    TwitchEvents.STATS_UPDATE,
    TwitchEvents.PROMPT_LOGIN_MODAL,
    TwitchEvents.PLAYER_READY,
    TwitchEvents.STITCHED_AD_START,
    TwitchEvents.STITCHED_AD_END,
];

export const allEvents = union(mediaEvents, customEvents);

export const debugIgnoreEvents = [
    MediaEvents.TIME_UPDATE,
    TwitchEvents.BUFFER_CHANGE,
];

// Only whitelist parameters that belong to 3rd party embeds
export const embedParameters = Object.freeze([
    // public parameters; see
    // https://github.com/justintv/Twitch-API/blob/master/embed-video.md
    // specifies which channel to load in the embed
    'channel',
    // specifies which VOD to load in the embed
    'video',
    // specifies which collection to load in the embed
    'collection',
    // whether the embed should begin playback in a default muted state
    'muted',
    // whether the embed should automatically begin playback when the content
    // stream loads
    'autoplay',
    // begin a VOD at the specified offset instead of the beginning
    'time',
    't', // alias of `time`, renamed for backwards compatibility
    // private parameters; these parameters must be available to third parties
    // such as Valve to ensure external integrations can set the correct value
    // for various properties

    // exposes additional debugging information via the JS console
    'debug',
    // exposes ad information via the JS console
    'debug_ads',
    // forces html5 as the backend
    'html5',
    // forces flash as the backend,
    'flash',
    // forces the quality to the specified value
    'quality',
    // if the player controls (e.g. play/pause) should be displayed
    'controls',
    // if the embed should be able to play inline inside mobile safari
    'playsinline',
    // stream id used for live to vod streams
    'stream',
    // channelId used for live to vod streams
    'channelId',
    // Twitch Tracking values for embeds
    'tt_content',
    'tt_medium',
    // Used only for debug purposes to force usage of a specific Usher node on LVS streams
    'force_manifest_node',
    // Used for postMessage origins
    'origin',
]);

// Each left/right key press increments or decrements the volume by 10%.
export const volumeStepAmount = 0.1;

// VAST URL for DoubleClick advertisements.
export const doubleClickVODUrl = '//pubads.g.doubleclick.net/gampad/ads';
export const doubleClickLiveUrl = '//pubads.g.doubleclick.net/gampad/live/ads';
export const imaNetworkID = '3576121';

// To prevent load spikes, we show a confirmation box on exit.
// This is only shown for large channels that have recently gone offline.
export const leaveDialog = {
    // Controls whether we try to show the dialog or not.
    // Can be overwritten via options for testing (leaveDialogEnabled).
    enabled: false,

    // If the channel ended more than x seconds ago, don't show the dialog box.
    sinceEnded: 45,

    // If the channel has less than x viewers, don't show the box.
    // Can be overwritten via options for testing (leaveDialogViewerThreshold).
    viewerThreshold: 50000,

    // Actual text for the confirmation box (except for Firefox).
    // eslint-disable-next-line max-len
    text: 'Don\'t panicBasket. The broadcast is down, but don\'t refresh just yet. When the broadcast is back, the player will automatically reload for you.',

    // Consider the page load a refresh if it's been less than x seconds
    // since the dialog was shown to the user.
    refreshTimeout: 20,

    // Show the refresh warning overlay for x seconds.
    warningDuration: 45,
};

export const defaultLanguage = 'en-US';

// Seek amount in seconds on VODs with hotkeys
export const hotkeySeekAmount = 5;

// Seek amount in seconds on Clips with hotkeys
export const clipsHotkeySeekAmount = 2;

// When we want to resume a VOD we don't want to force a resume if it would just end the VOD
// This is the number of seconds before the end of the VOD where it shouldn't resume
export const cancelResumeAmount = 120;

// When we want to resume a VOD from a livestream, we want to seek some time before when the user stopped streaming
// This is the number of seconds we push back the seek time when resuming from livestream
export const livestreamResumePushback = 30;

export const resumewatchingHost = `${apiHost}/api/resumewatching/`;

export const clipsAPIHost = 'https://clips.twitch.tv/api/v2/clips/';
