import assign from 'lodash/assign';
import { ACTION_SET_ACCESS_TOKEN_PARAMS } from '../actions/access-token';
import { ACTION_SET_PLAYER_TYPE } from '../actions/env';
import { ACTION_SET_ADBLOCK_DETECTED } from '../actions/ads';

export const DEFAULT_ACCESS_TOKEN = {
    /* eslint-disable camelcase */
    params: {
        need_https: false,
        adblock: false,
    },
    /* eslint-enable camelcase */
};

/**
 * Store reducer for Access Token parameters.
 *
 * @param {Object} token
 * @param {Action} action
 * @return {Object}
 */
export function accessToken(token = DEFAULT_ACCESS_TOKEN, action) {
    switch (action.type) {
    case ACTION_SET_ACCESS_TOKEN_PARAMS:
        return assign({}, token, {
            params: action.params,
        });
    case ACTION_SET_PLAYER_TYPE:
        return assign({}, token, {
            params: assign({}, token.params, {
                // eslint-disable-next-line camelcase
                player_type: action.playerType,
            }),
        });
    case ACTION_SET_ADBLOCK_DETECTED:
        return assign({}, token, {
            params: assign({}, token.params, {
                adblock: action.detected !== false,
            }),
        });
    default:
        return token;
    }
}
